// demo3.cpp
// Dans cet exemple, on demande la terminaison du
// du fils par signal, aprs rception du premier signal de trace


#include <iostream>
using namespace std;


#include <sys/ptrace.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>   


void ecoute_fils(pid_t fils)
{
  int status;
  for(;;)
    {
      wait(&status);
      if(WIFEXITED(status))
	{
	  cout << "Processus fils termin normalement" << endl;
	break;
	}
      if(WIFSIGNALED(status))
	{
	  cout << "Processus fils termin  cause d'un signal" << endl;
	  break;
	}
      cout << "Un signal a man du fils" << endl;
      ptrace(PTRACE_CONT, fils, NULL, SIGKILL);
    }
}


int main(int argc, char* argv[])
{
  pid_t fils;
    
  switch(fils = fork())
    {
    case -1:
      cout << "Erreur, impossible de forker" << endl;
      break;
    case 0:
      ptrace(PTRACE_TRACEME, 0, NULL, NULL);
      execl("./helloworld-as", "./helloworld-as", NULL, NULL);
      break;
    default:
      ecoute_fils(fils);
      break;
    }

  return 0;
}
