// Dans cet exemple, on extrait le numro
// du premier appel systme excut dans le fils
// et qui n'est pas forcment celui qu'on croit :) 
#include <iostream>
using namespace std;


#include <sys/ptrace.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>   
// pour la dfinition des indexes de registre
#include <sys/reg.h> 


void ecoute_fils(pid_t fils)
{
  int status;
  long reg_eax;

  for(;;)
    {
      wait(&status);
      if(WIFEXITED(status))
	{
	  cout << "Processus fils termin normalement" << endl;
	break;
	}
      if(WIFSIGNALED(status))
	{
	  cout << "Processus fils termin  cause d'un signal" << endl;
	}
      cout << "Un signal a man du fils" << endl;
      reg_eax = ptrace(PTRACE_PEEKUSER, fils, ORIG_EAX *4 , NULL);
      cout << "Il s'agit de l'appel systme n " << reg_eax << endl; 
      ptrace(PTRACE_CONT, fils, NULL, NULL);
    }
}


int main(int argc, char* argv[])
{
  pid_t fils;
    
  switch(fils = fork())
    {
    case -1:
      cout << "Erreur, impossible de forker" << endl;
      break;
    case 0:
      ptrace(PTRACE_TRACEME, 0, NULL, NULL);
      execl("./helloworld-as", "./helloworld-as", NULL, NULL);
      break;
    default:
      ecoute_fils(fils);
      break;
    }

  return 0;
}
