// Dans cet exemple, on modifie
// la chaine crite dans le fichier
// par le programme helloworld.cpp

#include <iostream>
#include <iomanip>
#include <cstring>
using namespace std;

#include <sys/ptrace.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <unistd.h>   
// pour la dfinition des indexes de registre
#include <sys/reg.h> 
// pour le structure accueillant le contenu des registres
#include <sys/user.h>

void poke_programmez(pid_t fils)
{
  cout << "POKE PROGRAMMEZ!" << endl;

  long reg_ecx;

  // au stade o nous sommes, les donnes de la chaine
  // que le fils doit normalement imprimer sont
  // pointes par le registre ECX
  reg_ecx = ptrace(PTRACE_PEEKUSER, fils, ECX * 4 , NULL);
  // Attention au little endian :)
  ptrace(PTRACE_POKEDATA, fils,
	     reg_ecx, 0x676F7250);
  reg_ecx += 4;
  ptrace(PTRACE_POKEDATA, fils,
	 reg_ecx, 0x6D6D6172);
  reg_ecx += 4;
  ptrace(PTRACE_POKEDATA, fils,
	 reg_ecx, 0x0A217A65);
}

void print_regs(pid_t fils)
{
  struct user_regs_struct regs;
  
  ptrace(PTRACE_GETREGS, fils, NULL, &regs);
  cout << hex;
  cout << "EAX: " << setw(8) << setfill('0') << regs.eax << endl;
  cout << "EBX: " << setw(8) << setfill('0') << regs.ebx << endl;
  cout << "ECX: " << setw(8) << setfill('0') << regs.ecx << endl;
  cout << "EDX: " << setw(8) << setfill('0') << regs.edx << endl;
  cout << "ESI: " << setw(8) << setfill('0') << regs.esi << endl;
  cout << "EDI: " << setw(8) << setfill('0') << regs.edi << endl;
  cout << "EBP: " << setw(8) << setfill('0') << regs.ebp << endl;
  cout << "XDS: " << setw(8) << setfill('0') << regs.xds << endl;
  cout << "XES: " << setw(8) << setfill('0') << regs.xes << endl;
  cout << "XFS: " << setw(8) << setfill('0') << regs.xfs << endl;
  cout << "XGS: " << setw(8) << setfill('0') << regs.xgs << endl;
  cout << "EIP: " << setw(8) << setfill('0') << regs.eip << endl;
  cout << "XCS: " << setw(8) << setfill('0') << regs.xcs << endl;
  cout << "EFLAGS: " << setw(8) << setfill('0') << regs.eflags << endl;
  cout << "ESP: " << setw(8) << setfill('0') << regs.esp << endl;
  cout << "XSS: " << setw(8) << setfill('0') << regs.xss << endl;
  cout << dec << endl;
}

void ecoute_fils(pid_t fils)
{
  int status;
  long reg_eax;
  bool entree = true;

  // Les deux lignes ci-dessous servent
  //  passer l'appel  execve (alias execl) 
  wait(&status);
  ptrace(PTRACE_SYSCALL, fils, NULL, NULL);
  for(;;)
    {
      cout << "\n\n--------------------------\n\n";

      wait(&status);
      if(WIFEXITED(status))
	{
	  cout << "Processus fils termin normalement" << endl;
	break;
	}
      if(WIFSIGNALED(status))
	{
	  cout << "Processus fils termin  cause d'un signal" << endl;
	}
      if(entree)
	{
	  cout << "Entre dans l'appel systme: ";
	  reg_eax = ptrace(PTRACE_PEEKUSER, fils, ORIG_EAX *4 , NULL);
	  cout << reg_eax << endl;
	  cout << "Contenu des registres:" << endl;
	  print_regs(fils);
	  // Si l'appel systle est write
	  // on bidouille le fils
	  if(reg_eax == 4)
	      poke_programmez(fils);
	  entree = false;
	  ptrace(PTRACE_SYSCALL, fils, NULL, NULL);
	  continue;
	}
      if(!entree) // donc sortie :)
	{
	  cout << "Sortie de l'appel systme: ";
	  reg_eax = ptrace(PTRACE_PEEKUSER, fils, ORIG_EAX *4 , NULL);
	  cout << reg_eax << endl;
	  cout << "Contenu des registres:" << endl << endl;
	  print_regs(fils);
	  reg_eax = ptrace(PTRACE_PEEKUSER, fils, EAX *4 , NULL);
	  cout << "Valeur de retour de l'appel: " << reg_eax << endl;
	  entree = true;
	  ptrace(PTRACE_SYSCALL, fils, NULL, NULL);
	  continue;
	}
    }
}


int main(int argc, char* argv[])
{
  pid_t fils;
    
  switch(fils = fork())
    {
    case -1:
      cout << "Erreur, impossible de forker" << endl;
      break;
    case 0:
      ptrace(PTRACE_TRACEME, 0, NULL, NULL);
      execl("./helloworld", "./helloworld", NULL, NULL);
      break;
    default:
      ecoute_fils(fils);
      break;
    }

  return 0;
}
