/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.user.client.ui;

import com.google.gwt.dom.client.Element;
import com.google.gwt.event.dom.client.DomEvent;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerManager;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.event.shared.HasHandlers;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.UIObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Widget
extends UIObject
implements EventListener,
HasHandlers {
    int eventsToSink;
    private boolean attached;
    private Object layoutData;
    private Widget parent;
    private HandlerManager handlerManager;

    @Override
    public void fireEvent(GwtEvent<?> event) {
        if (this.handlerManager != null) {
            this.handlerManager.fireEvent(event);
        }
    }

    public Widget getParent() {
        return this.parent;
    }

    public boolean isAttached() {
        return this.attached;
    }

    @Override
    public void onBrowserEvent(Event event) {
        switch (DOM.eventGetType(event)) {
            case 16: 
            case 32: {
                Element related = event.getRelatedTarget();
                if (related == null || !this.getElement().isOrHasChild(related)) break;
                return;
            }
        }
        DomEvent.fireNativeEvent(event, this, this.getElement());
    }

    public void removeFromParent() {
        if (this.parent == null) {
            if (RootPanel.isInDetachList(this)) {
                RootPanel.detachNow(this);
            }
        } else if (this.parent instanceof HasWidgets) {
            ((HasWidgets)((Object)this.parent)).remove(this);
        } else if (this.parent != null) {
            throw new IllegalStateException("This widget's parent does not implement HasWidgets");
        }
    }

    @Override
    public void sinkEvents(int eventBitsToAdd) {
        if (this.isOrWasAttached()) {
            super.sinkEvents(eventBitsToAdd);
        } else {
            this.eventsToSink |= eventBitsToAdd;
        }
    }

    protected final <H extends EventHandler> HandlerRegistration addDomHandler(H handler, DomEvent.Type<H> type) {
        assert (handler != null) : "handler must not be null";
        assert (type != null) : "type must not be null";
        this.sinkEvents(Event.getTypeInt(type.getName()));
        return this.ensureHandlers().addHandler(type, handler);
    }

    protected final <H extends EventHandler> HandlerRegistration addHandler(H handler, GwtEvent.Type<H> type) {
        return this.ensureHandlers().addHandler(type, handler);
    }

    protected void delegateEvent(Widget target, GwtEvent<?> event) {
        target.fireEvent(event);
    }

    protected void doAttachChildren() {
    }

    protected void doDetachChildren() {
    }

    protected int getHandlerCount(GwtEvent.Type<?> type) {
        return this.handlerManager == null ? 0 : this.handlerManager.getHandlerCount(type);
    }

    protected final boolean isOrWasAttached() {
        return this.eventsToSink == -1;
    }

    protected void onAttach() {
        if (this.isAttached()) {
            throw new IllegalStateException("Should only call onAttach when the widget is detached from the browser's document");
        }
        this.attached = true;
        DOM.setEventListener(this.getElement(), this);
        int bitsToAdd = this.eventsToSink;
        this.eventsToSink = -1;
        if (bitsToAdd > 0) {
            this.sinkEvents(bitsToAdd);
        }
        this.doAttachChildren();
        this.onLoad();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDetach() {
        if (!this.isAttached()) {
            throw new IllegalStateException("Should only call onDetach when the widget is attached to the browser's document");
        }
        try {
            this.onUnload();
        }
        finally {
            this.doDetachChildren();
            DOM.setEventListener(this.getElement(), null);
            this.attached = false;
        }
    }

    protected void onLoad() {
    }

    protected void onUnload() {
    }

    HandlerManager ensureHandlers() {
        return this.handlerManager == null ? (this.handlerManager = new HandlerManager(this)) : this.handlerManager;
    }

    HandlerManager getHandlerManager() {
        return this.handlerManager;
    }

    Object getLayoutData() {
        return this.layoutData;
    }

    @Override
    void replaceElement(Element elem) {
        if (this.isAttached()) {
            DOM.setEventListener(this.getElement(), null);
        }
        super.replaceElement(elem);
        if (this.isAttached()) {
            DOM.setEventListener(this.getElement(), this);
        }
    }

    void setLayoutData(Object layoutData) {
        this.layoutData = layoutData;
    }

    void setParent(Widget parent) {
        Widget oldParent = this.parent;
        if (parent == null) {
            if (oldParent != null && oldParent.isAttached()) {
                this.onDetach();
                assert (!this.isAttached()) : "Failure of " + this.getClass().getName() + " to call super.onDetach()";
            }
            this.parent = null;
        } else {
            if (oldParent != null) {
                throw new IllegalStateException("Cannot set a new parent without first clearing the old parent");
            }
            this.parent = parent;
            if (parent.isAttached()) {
                this.onAttach();
                assert (this.isAttached()) : "Failure of " + this.getClass().getName() + " to call super.onAttach()";
            }
        }
    }
}

