package fr.test.ooo;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.XPropertySet;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.drawing.XShape;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.HoriOrientation;
import com.sun.star.text.VertOrientation;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.Exception;

/** 
 * Helper facilitant la création d'un OLE Chart pour OOo
 * NB : code récupéré et adapté depuis les exemples fournis
 * par OOo
 * 
 * @author Bjoumlrn Milcke
 * @author Sylvain Saurel
 */
public class ChartHelper
{
	/** ID pour le chart */
    private static final String MS_CHART_CLASS_ID = "12dcae26-281f-416f-a234-c3086127382e";
    /** Modèle auquel ajouté le chart */
    private XModel xModel;
	
    /**
     * Constructeur
     * 
     * @param xModel Modèle auquel sera ajouté le chart
     */
    public ChartHelper(XModel xModel){
    	this.xModel = xModel;
    }

    /**
     * Création et insertion d'un chart OLE dans le document Writer ocnsidéré
     * 
     * @param chartName Nom du chart
     * @param ptUpperLeft Position coin supérieur gauche
     * @param size Taille
     * @param chartServiceName Nom du service chart
     * @return Le chart crée, <code>null</code> en cas d'erreur
     * @throws Exception
     */
    public XChartDocument insertOLEChartInWriter(String chartName, Point ptUpperLeft, Size size, String chartServiceName ) throws Exception{
        XChartDocument xChartDocument = null;

        if(chartName != null  &&  ptUpperLeft != null  &&  size != null  &&  chartServiceName != null){
        	XMultiServiceFactory xMultiServiceFactory = OOoUtils.getInterface(XMultiServiceFactory.class, xModel);
        	
            if(xMultiServiceFactory != null){
                XTextContent xTextContent = OOoUtils.getInterface(XTextContent.class, xMultiServiceFactory.
                		createInstance("com.sun.star.text.TextEmbeddedObject"));

                if(xTextContent != null){
                	XPropertySet xPropSet = OOoUtils.getInterface(XPropertySet.class, xTextContent);
                    xPropSet.setPropertyValue("CLSID", MS_CHART_CLASS_ID);
                    XTextDocument xTextDoc = OOoUtils.getInterface(XTextDocument.class, xModel);
                    XText xText = xTextDoc.getText();
                    XTextCursor xCursor = xText.createTextCursor();
                    // Insertion de l'objet dans le texte
                    xText.insertTextContent(xCursor, xTextContent, true);
                    // Configuration de la taille et de la position de l'objet
                    XShape xShape = OOoUtils.getInterface(XShape.class, xTextContent);
                    xShape.setSize(size);
                    xPropSet.setPropertyValue("VertOrient", new Short(VertOrientation.NONE));
                    xPropSet.setPropertyValue("HoriOrient", new Short(HoriOrientation.NONE));
                    xPropSet.setPropertyValue("VertOrientPosition", new Integer(ptUpperLeft.Y));
                    xPropSet.setPropertyValue("HoriOrientPosition", new Integer(ptUpperLeft.X));
                    // Récupération du chart document comme model de la forme OLE
                    xChartDocument = OOoUtils.getInterface(XChartDocument.class, xPropSet.getPropertyValue("Model"));
                    // Création d'un diagramme et mise en place dans le xChartDocument
                    xChartDocument.setDiagram(OOoUtils.getInterface(XDiagram.class, OOoUtils.
                    		getInterface(XMultiServiceFactory.class, xChartDocument).createInstance(chartServiceName)));
                }   
            }
        }

        return xChartDocument;
    }
}
