package fr.test.samples;

import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XComponent;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.uno.Exception;

import fr.test.ooo.OOoUtils;
import fr.test.utils.DocumentType;
import fr.test.utils.SaveFormat;
import fr.test.utils.Utils;

/**
 * Classe exemple détaillant la
 * création d'un fichier Calc
 * 
 * @author Sylvain Saurel
 *
 */
public class CalcGenSample {

	/**
	 * Méthode main
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		XComponentLoader xComponentLoader = null;
		XComponent xComponent = null;
		
		try {
			// Récupération d'une instance distante OOo
			//xComponentLoader = OOoUtils.getRemoteXComponentLoader("localhost", "8100");
			// Récupération d'une instance locale OOo
			xComponentLoader = OOoUtils.getLocalXComponentLoader();
			
			if(xComponentLoader != null){
				xComponent = OOoUtils.loadNewComponent(xComponentLoader, DocumentType.CALC, true);
			}
		}catch(BootstrapException bse) {
			System.out.println("Erreur à la récupération du contexte : " + bse.getMessage());
		}catch(Exception exc){
			System.out.println("Erreur au chargement du composant : " + exc.getMessage());
		}

		// Travail sur le document
		if(xComponent != null){
			// Ecriture des données de la feuille de calcul
			printData(xComponent);
			// Sauvegarde
			boolean save = OOoUtils.saveDocument("I:/", "testCalc", xComponent, SaveFormat.ODS, true);
			System.out.println("La sauvegarde a " + ((save) ? "réussi" : "échoué"));
			// Fermeture
			OOoUtils.closeOrDisposeInstance(xComponent);
			System.exit(0);
		}
		
	}
	
	/**
	 * Méthode permettant d'écrire des données dans le document
	 * calc passé en entrée
	 * 
	 * @param xComponent Document calc sur lequel les données doivent être écrites
	 */
	public static void printData(XComponent xComponent){
		// Récupération d'une implémentation de l'interface XSpreadSheetDocument
		XSpreadsheetDocument xSpreadSheetDocument = OOoUtils.getInterface(XSpreadsheetDocument.class, xComponent);
		// On récupère les feuilles de calcul du xSpreadSheetDocument chargé
		XSpreadsheets xSpreadSheets = xSpreadSheetDocument.getSheets();
		// Création de la feuille de calcul SheetSample
		xSpreadSheets.insertNewByName("SheetSample", (short)0);
		XSpreadsheet xSpreadSheet = null;
		
		try {
			// Récupération de la feuille de calcul créée
			xSpreadSheet = OOoUtils.getInterface(XSpreadsheet.class, xSpreadSheets.getByName("SheetSample"));
		}catch(Exception exc) {
			System.out.println("La feuille de style SheetSample n'existe pas : " + exc.getMessage());
		}
	
		if(xSpreadSheet != null){
			try {
				// Insertion des headers de la feuille de calcul SheetSample
				OOoUtils.insertIntoCalcCell(0, 0, "X", xSpreadSheet, true);
				OOoUtils.insertIntoCalcCell(1, 0, "Y", xSpreadSheet, true);
				OOoUtils.insertIntoCalcCell(2, 0, "Z", xSpreadSheet, true);
				OOoUtils.insertIntoCalcCell(3, 0, "Sum", xSpreadSheet, true);
				// Insertion des données
				for(int row = 1; row < 5; row++){
					for(int col = 0; col < 3; col++){
						OOoUtils.insertIntoCalcCell(col, row, Utils.getRandomDouble(), xSpreadSheet, true);
					}
					// Mise en place des formules
					OOoUtils.insertIntoCalcCell(3, row, new StringBuilder("=SUM(").append(OOoUtils.intColToCharCol(0)).
							append(row+1).append(':').append(OOoUtils.intColToCharCol(2)).append(row+1).append(')').
							toString(), xSpreadSheet, false);
				}
			}catch(IndexOutOfBoundsException ioobe){
				System.out.println("Erreur de coordonnées de cellule : " + ioobe.getMessage());
			}	
		}
		
		
		
	}
	
}
