package fr.test.samples;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.XPropertySet;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.drawing.XDrawPage;
import com.sun.star.drawing.XDrawPages;
import com.sun.star.drawing.XDrawPagesSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XText;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;

import fr.test.ooo.OOoUtils;
import fr.test.utils.DocumentType;
import fr.test.utils.SaveFormat;

/**
 * Classe exemple détaillant la
 * création d'un fichier Draw
 * 
 * @author Sylvain Saurel
 *
 */
public class DrawGenSample {

	/**
	 * Méthode main
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		XComponentLoader xComponentLoader = null;
		XComponent xComponent = null;
		
		try {
			// Récupération d'une instance distante OOo
			//xComponentLoader = OOoUtils.getRemoteXComponentLoader("localhost", "8100");
			// Récupération d'une instance locale OOo
			xComponentLoader = OOoUtils.getLocalXComponentLoader();
			
			if(xComponentLoader != null){
				xComponent = OOoUtils.loadNewComponent(xComponentLoader, DocumentType.DRAW, true);
			}
		}catch(BootstrapException bse) {
			System.out.println("Erreur à la récupération du contexte : " + bse.getMessage());
		}catch(Exception exc){
			System.out.println("Erreur au chargement du composant : " + exc.getMessage());
		}

		// Travail sur le document
		if(xComponent != null){
			// Ecriture des données du document Draw
			try {
				printDraw(xComponent);
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			// Sauvegarde
			boolean save = OOoUtils.saveDocument("I:/", "testDraw", xComponent, SaveFormat.ODG, true);
			System.out.println("La sauvegarde a " + ((save) ? "réussi" : "échoué"));
			// Fermeture
			OOoUtils.closeOrDisposeInstance(xComponent);
			System.exit(0);
		}
		
	}
	
	/**
	 * Méthode permettant d'écrire un organigramme dans 
	 * le document Draw passé en entrée
	 * NB : Exemple récupéré du SDK et adapté
	 * 
	 * @param xComponent Le document Draw sur lequel on souhaite écrire
	 * @throws Exception
	 */
	public static void printDraw(XComponent xComponent) throws Exception{
	    // Récupération de l'implémentation de l'interface XDrawPagesSupplier
        XDrawPagesSupplier xDrawPagesSupplier = OOoUtils.getInterface(XDrawPagesSupplier.class, xComponent);
        // Récupération des pages Draw
        XDrawPages xDrawPages = xDrawPagesSupplier.getDrawPages();
        // Récupération d'une référence sur la première page Draw du document
        XDrawPage xDrawPage = OOoUtils.getInterface(XDrawPage.class, xDrawPages.getByIndex(0));
        // Récupération d'une implémentation de XMultiServiceFactory
        XMultiServiceFactory xMultiServiceFactory = OOoUtils.getInterface(XMultiServiceFactory.class, xComponent);
        // Récupération des propriétés liées aux dimensions de la page Draw
        XPropertySet xPageProps = OOoUtils.getInterface(XPropertySet.class, xDrawPage);
        int pageWidth = AnyConverter.toInt(xPageProps.getPropertyValue("Width"));
        int pageHeight = AnyConverter.toInt(xPageProps.getPropertyValue("Height"));
        int pageBorderTop = AnyConverter.toInt(xPageProps.getPropertyValue("BorderTop"));
        int pageBorderLeft = AnyConverter.toInt(xPageProps.getPropertyValue("BorderLeft"));
        int pageBorderRight = AnyConverter.toInt(xPageProps.getPropertyValue("BorderRight"));
        // Largeur de la zone de dessin
        int drawWidth = pageWidth - pageBorderLeft - pageBorderRight;
        // Milieu à l'horizontal
        int horCenter = pageBorderLeft + drawWidth / 2;
        // Définition des données de l'organigramme
        String[][] orgUnits = new String[2][4];
        orgUnits[0][0] = "Management";
        orgUnits[1][0] = "Production";
        orgUnits[1][1] = "Marketing";
        orgUnits[1][2] = "IT Services";
        orgUnits[1][3] = "Ventes";
        // Nombre d'éléments par niveaux
        int[] levelCount = {1, 4};
        // Espaces
        int horSpace = 300;
        int verSpace = 3000;
        // Dimension des Formes 
        int shapeWidth = (drawWidth - (levelCount[1] - 1) * horSpace) / levelCount[1];
        int shapeHeight = pageHeight / 20;
        int shapeX = pageWidth / 2 - shapeWidth / 2;     
        int levelY = 0;
        // Racine de l'organigramme
        XShape xRootShape = null;
        
        // Parcours des différents niveaux
        for (int level = 0; level <= 1; level++) {
            levelY = pageBorderTop + 2000 + level * (shapeHeight + verSpace);
            // Parcours des éléments du niveau courant
            for (int i = levelCount[level] - 1; i > -1; i--) {
                shapeX = horCenter - (levelCount[level] * shapeWidth + (levelCount[level] - 1)
                		* horSpace) / 2 + i * shapeWidth + i * horSpace;
                Object shape = xMultiServiceFactory.createInstance("com.sun.star.drawing.RectangleShape");
                XShape xShape = OOoUtils.getInterface(XShape.class, shape);
                xShape.setPosition(new Point(shapeX, levelY));
                xShape.setSize(new Size(shapeWidth, shapeHeight)); 
                // Ajout à la page Draw
                xDrawPage.add(xShape);
                // Ecriture du texte dans la forme rectangulaire
                XText xText = OOoUtils.getInterface(XText.class, xShape);
                
                xText.setString(orgUnits[level][i]);                

                // Mémorisation de la racine de l'organigramme
                if(level == 0  &&  i == 0){
                	xRootShape = xShape; 
                }
                
                if(level >= 1){
                	// Création d'une liaison entre les éléments liés de l'organigramme
                    Object connector = xMultiServiceFactory.createInstance("com.sun.star.drawing.ConnectorShape");
                    XShape xConnector = OOoUtils.getInterface(XShape.class, connector);
                    // Ajout de la liaison entre les éléments liés de l'organigramme
                    xDrawPage.add(xConnector);
                    // Configuration des propriétés de la liaison
                    XPropertySet xConnectorProps = OOoUtils.getInterface(XPropertySet.class, connector);
                    xConnectorProps.setPropertyValue("StartShape", xRootShape);
                    xConnectorProps.setPropertyValue("EndShape", xShape);
                    xConnectorProps.setPropertyValue("StartGluePointIndex", new Integer(2)); 
                    xConnectorProps.setPropertyValue("EndGluePointIndex", new Integer(0));
                }                
            }
        }

	}
	
}
