package fr.test.samples;

import java.awt.Color;

import com.sun.star.awt.Point;
import com.sun.star.awt.Size;
import com.sun.star.beans.XPropertySet;
import com.sun.star.chart.X3DDisplay;
import com.sun.star.chart.XAxisXSupplier;
import com.sun.star.chart.XAxisYSupplier;
import com.sun.star.chart.XChartDataArray;
import com.sun.star.chart.XChartDocument;
import com.sun.star.chart.XDiagram;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.drawing.FillStyle;
import com.sun.star.drawing.XDrawPageSupplier;
import com.sun.star.drawing.XShape;
import com.sun.star.drawing.XShapes;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XModel;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.ControlCharacter;
import com.sun.star.text.TextContentAnchorType;
import com.sun.star.text.XText;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.uno.Exception;

import fr.test.ooo.ChartHelper;
import fr.test.ooo.OOoUtils;
import fr.test.utils.DocumentType;
import fr.test.utils.SampleData;
import fr.test.utils.SaveFormat;
import fr.test.utils.Utils;

/**
 * Classe contenant des exemples d'écriture
 * de documents Writer
 * 
 * @author Sylvain Saurel
 *
 */
public class WriterGenSample {
	
	/**
	 * Méthode main
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		XComponentLoader xComponentLoader = null;
		XComponent xComponent = null;
		
		try {
			// Récupération d'une instance distante OOo
			// xComponentLoader = OOoUtils.getRemoteXComponentLoader("localhost", "8100");
			// Récupération d'une instance locale OOo
			xComponentLoader = OOoUtils.getLocalXComponentLoader();
			if(xComponentLoader != null){
				xComponent = OOoUtils.loadNewComponent(xComponentLoader, DocumentType.WRITER, true);
			}
		}catch(BootstrapException bse) {
			System.out.println("Erreur à la récupération du contexte : " + bse.getMessage());
		}catch(Exception exc){
			System.out.println("Erreur au chargement du composant : " + exc.getMessage());
		}

		// Travail sur le document
		if(xComponent != null){
			printDrawWithText(xComponent);
			printTable(xComponent);
			printChart(xComponent);
			// Sauvegarde
			boolean save = OOoUtils.saveDocument("I:/", "test", xComponent, SaveFormat.PDF, true);
			System.out.println("La sauvegarde a " + ((save) ? "réussi" : "échoué"));
			// Fermeture
			OOoUtils.closeOrDisposeInstance(xComponent);
			System.exit(0);
		}
	}
	
	/**
	 * Affiche une table sur le document du xComponent
	 * 
	 * @param xComponent Document sur lequel la table est écrite
	 */
	public static void printTable(XComponent xComponent){
        try{
            // Récupération de l'interface XTextDocument depuis le XComponent
    		XTextDocument xTextDocument = OOoUtils.getInterface(XTextDocument.class, xComponent);
            XText xText = xTextDocument.getText();
            // création d'un curseur texte
            XTextCursor xTextCursor = xText.createTextCursor();
            for(int i = 0; i < 11; i ++){
            	xText.insertControlCharacter(xTextCursor,ControlCharacter.PARAGRAPH_BREAK, false);
            }
            // Récupération de l'interface XMultiServiceFactory
			XMultiServiceFactory mxDocFactory = OOoUtils.getInterface(XMultiServiceFactory.class, xTextDocument);
			// Création d'une table
            XTextTable xTable = OOoUtils.getInterface( XTextTable.class, mxDocFactory.createInstance("com.sun.star.text.TextTable"));
            // Initialisation du nombre de colonnes et du nombre de lignes
            xTable.initialize(4, 4);
            // Insertion de la table dans le document
            xText.insertTextContent(xTextCursor, xTable, false);
            // Récupération de XIndexAccess sur les lignes de la table
            XIndexAccess xRows = xTable.getRows();
            // Configuration des propriétés de la première ligne de la table
            XPropertySet xRow = OOoUtils.getInterface(XPropertySet.class, xRows.getByIndex(0));
            xRow.setPropertyValue("BackTransparent", Boolean.FALSE);
            xRow.setPropertyValue("BackColor", Utils.ColorToIntegerValue(new Color(102, 102, 148)));
            // Configuration des propriétés de la table
            XPropertySet xTableProps = OOoUtils.getInterface(XPropertySet.class, xTable);
            xTableProps.setPropertyValue("BackTransparent", Boolean.FALSE);
            xTableProps.setPropertyValue("BackColor", Utils.ColorToIntegerValue(new Color(204, 204, 255)));
            // Insertion du contenu dans les cellules de la première ligne
            OOoUtils.insertIntoCell(xTable, "A1", "First Column", Color.WHITE);
            OOoUtils.insertIntoCell(xTable, "B1", "Second Column", Color.WHITE);
            OOoUtils.insertIntoCell(xTable, "C1", "Third Column", Color.WHITE);
            OOoUtils.insertIntoCell(xTable, "D1", "Results", Color.WHITE);
            // Insertion de données aléatoires dans lignes suivantes
            for(int row = 2; row <= 4; row++){
            	for(char col = 'A'; col <= 'C'; col++){
            		xTable.getCellByName(new StringBuilder().append(col).append(row).toString()).setValue(Utils.getRandomDouble());
            	}
                // Mise en place d'une formule sur la 4ème colonne qui va calculer la
            	// somme des 3 premières colonnes
            	xTable.getCellByName(new StringBuilder().append('D').append(row).toString()).
            			setFormula(new StringBuilder("sum<A").append(row).append(":C").
            					append(row).append('>').toString());
            }
            
        }catch(Exception exc){
        	System.out.println("Erreur durant la création de la table : " + exc.getMessage());
        }
	}
	
	/**
	 * Affichage un dessin, une image et du texte dans le document
	 * associé au xComponent
	 * 
	 * @param xComponent Document sur lequel se fait l'affichage
	 */
	public static void printDrawWithText (XComponent xComponent) { 
	    try {
            // Récupération de l'interfaxe XTextDocument via le XComponent
    		XTextDocument xTextDocument = OOoUtils.getInterface(XTextDocument.class, xComponent);
    		// Récupération de l'interface XMultiServiceFactory
    		XMultiServiceFactory xMultiServiceFactory = OOoUtils.getInterface(XMultiServiceFactory.class, xTextDocument);
	        // Création d'un objet RectagnleShape
	        XShape xRect = OOoUtils.getInterface(XShape.class, xMultiServiceFactory.
	        		createInstance("com.sun.star.drawing.RectangleShape"));
	        // Configuration de sa taille et de son positionnement
	        xRect.setPosition(new Point(500, 500));
	        xRect.setSize(new Size(9500,3500));
	        // Configuration de ses propriétés OOo
	        XPropertySet xRectProps = OOoUtils.getInterface(XPropertySet.class, xRect);
	        xRectProps.setPropertyValue("AnchorType", TextContentAnchorType.AT_PARAGRAPH);
	        xRectProps.setPropertyValue("CornerRadius", new Integer(1000));
	        xRectProps.setPropertyValue("Shadow", Boolean.TRUE);
	        xRectProps.setPropertyValue("ShadowXDistance", new Integer(125));
	        xRectProps.setPropertyValue("ShadowYDistance", new Integer(125));
	        xRectProps.setPropertyValue("ShadowColor", new Integer(0xc0c0c0));
	        // Récupération de l'interface XDrawPageSupplier
	        XDrawPageSupplier xDrawPageSupplier = OOoUtils.getInterface(XDrawPageSupplier.class, xComponent);
	        // Récupération de l'interface XShape de l'objet DrawPage
	        XShapes xShapes = OOoUtils.getInterface(XShapes.class, xDrawPageSupplier.getDrawPage());
	        // ajout du rectangle
	        xShapes.add(xRect);
	        
	        // ajout de texte dans le rectangle
	        XText xShapeText = OOoUtils.getInterface(XText.class, xRect);
	        OOoUtils.insertTextInXText(xShapeText, "\n\nLisez Programmez ! ;)");
	        
	        // Ajout d'une image
	        OOoUtils.addImagetoXShapes(xMultiServiceFactory, xShapes, "/fr/test/images/logo.jpg");
	       
	    }catch(Exception exc) {
	        System.out.println("Exception durant la création de l'image : " + exc.getMessage());
	    }
	}
    
	/**
	 * Affichage d'un chart OLE dans le document associé au xComponent
	 * 
	 * @param xComponent Document sur lequel on souhaite afficher le chart
	 */
    public static void printChart(XComponent xComponent){
    	try{
	    	// Création de l'objet ChartHelper
			ChartHelper chartHelper = new ChartHelper(OOoUtils.getInterface(XModel.class, xComponent));
			// Création du ChartDocument
	        XChartDocument chartDoc = chartHelper.insertOLEChartInWriter("Chart", new Point(1000, 9000),
	        		new Size(15000, 13000), "com.sun.star.chart.BarDiagram");
	        // Configuration des propriétés du ChartDocument
	        XPropertySet pChartDoc = OOoUtils.getInterface(XPropertySet.class, chartDoc);
	        pChartDoc.setPropertyValue("HasMainTitle", Boolean.TRUE);
	        XPropertySet pChartDocTitle = OOoUtils.getInterface(XPropertySet.class, OOoUtils.getInterface(XShape.class, chartDoc.getTitle()));
	        pChartDocTitle.setPropertyValue("String", "Part de marché des navigateurs");
	        XChartDataArray chartDataArray = OOoUtils.getInterface(XChartDataArray.class, chartDoc.getData());
	        // Création des données du Chart
	        SampleData sampleData = new SampleData();
	        chartDataArray.setData(sampleData.getData());
	        chartDataArray.setColumnDescriptions(sampleData.getColumnDescriptions());
	        chartDataArray.setRowDescriptions(sampleData.getRowDescriptions());
	        // On récupère le diagramme associé au XChartDocument
	        XDiagram xDiagram = chartDoc.getDiagram();   
	        // Configuration des axes
	        XPropertySet pSet = OOoUtils.getInterface(XPropertySet.class, xDiagram);
	        pSet.setPropertyValue("HasXAxisTitle", Boolean.TRUE);
	        pSet.setPropertyValue("HasYAxisTitle", Boolean.TRUE);
	        // Mise en place d'un titre sur l'axe X
	        XShape shape = OOoUtils.getInterface(XAxisXSupplier.class, xDiagram).getXAxisTitle();
	        pSet = OOoUtils.getInterface(XPropertySet.class, shape);
	        pSet.setPropertyValue("String", "Années");
	        // Mise en place d'un titre sur l'axe Y
	        XAxisYSupplier yAxis = OOoUtils.getInterface(XAxisYSupplier.class, xDiagram);
	        shape = yAxis.getYAxisTitle();
	        pSet = OOoUtils.getInterface(XPropertySet.class, shape);
	        pSet.setPropertyValue("String", "Part de marché %");
	        // Coloration des lignes en Y
	        pSet = yAxis.getYMainGrid();
	        pSet.setPropertyValue("LineColor", Utils.ColorToIntegerValue(new Color(238, 238, 238)));
	        // Configuration des propriétés d'affichage
	        XPropertySet wall = OOoUtils.getInterface(X3DDisplay.class, xDiagram).getWall();
			wall.setPropertyValue("FillColor", Utils.ColorToIntegerValue(new Color(210,210,210)));
			wall.setPropertyValue("FillStyle",  FillStyle.SOLID);
			
    	}catch(Exception exc){
    		System.out.println("Exception durant la création du Chart : " + exc.getMessage());
    	}
    }
    
}
