package fr.test.samples;

import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.XComponent;
import com.sun.star.text.XText;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextRange;
import com.sun.star.uno.Exception;

import fr.test.ooo.OOoUtils;
import fr.test.utils.DocumentType;
import fr.test.utils.SaveFormat;

/**
 * Classe exemple écrivant un HelloWorld dans
 * un document Writer
 * 
 * @author Sylvain Saurel
 *
 */
public class WriterHelloWorld {

	/**
	 * Méthode main
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		XComponentLoader xComponentLoader = null;
		XComponent xComponent = null;
		
		try {
			// Récupération d'une instance distante OOo
			xComponentLoader = OOoUtils.getRemoteXComponentLoader("localhost", "8100");
			// Récupération d'une instance locale OOo
			//xComponentLoader = OOoUtils.getLocalXComponentLoader();
			
			if(xComponentLoader != null){
				xComponent = OOoUtils.loadNewComponent(xComponentLoader, DocumentType.WRITER, true);
			}
		}catch(BootstrapException bse) {
			System.out.println("Erreur à la récupération du contexte : " + bse.getMessage());
		}catch(Exception exc){
			System.out.println("Erreur au chargement du composant : " + exc.getMessage());
		}

		// Travail sur le document
		if(xComponent != null){
			printHelloWorld(xComponent);
			// Sauvegarde
			boolean save = OOoUtils.saveDocument("I:/", "helloWorld", xComponent, SaveFormat.PDF, true);
			System.out.println("La sauvegarde a " + ((save) ? "réussi" : "échoué"));
			// Fermeture
			OOoUtils.closeOrDisposeInstance(xComponent);
			System.exit(0);
		}
		
	}
	
	/**
	 * Méthode permettant d'écrire un Hello World ;)
	 * dans un document Writer
	 * 
	 * @param xComponent
	 */
	public static void printHelloWorld(XComponent xComponent) {
		// Récupération de l'interface XTextDocument associée
		XTextDocument xTextDocument = OOoUtils.getInterface(XTextDocument.class, xComponent);
		// Accès à la partie texte du document
		XText xText = xTextDocument.getText();
		// Positionnement à la fin de la zone de texte
		XTextRange xTextRange = xText.getEnd();
		// Ecriture
		xTextRange.setString("Hello World !\n");
		xTextRange = xText.getEnd();
		xTextRange.setString("Lisez Programmez !\n");
	}
	
}
