package fr.test.samples;

import com.sun.star.beans.XPropertySet;
import com.sun.star.comp.helper.BootstrapException;
import com.sun.star.container.XIndexAccess;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.lang.XComponent;
import com.sun.star.table.XTableColumns;
import com.sun.star.table.XTableRows;
import com.sun.star.text.XText;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextTable;
import com.sun.star.text.XTextTablesSupplier;
import com.sun.star.uno.Exception;

import fr.test.ooo.OOoUtils;

/**
 * Classe d'exemple de lecture de documents Writer
 * 
 * @author Sylvain Saurel
 *
 */
public class WriterReadSample {
	
	/**
	 * Méthode main
	 * 
	 * @param args
	 */
	public static void main(String[] args) {
		XComponentLoader xComponentLoader = null;
		XComponent xComponent = null;
		
		try {
			// Récupération d'une instance distante OOo
			 xComponentLoader = OOoUtils.getRemoteXComponentLoader("localhost", "8100");
			// Récupération d'une instance locale OOo
			//xComponentLoader = OOoUtils.getLocalXComponentLoader();
			if(xComponentLoader != null){
				//xComponent = OOoUtils.loadComponent(xComponentLoader, "file:///I:/helloWorld.odt", true);
				xComponent = OOoUtils.loadComponent(xComponentLoader, "file:///I:/testTable.odt", true);
			}
		}catch(BootstrapException bse) {
			System.out.println("Erreur à la récupération du contexte : " + bse.getMessage());
		}catch(Exception exc){
			System.out.println("Erreur au chargement du composant : " + exc.getMessage());
		}
		
		if(xComponent != null){
			//readText(xComponent);
			try{
				readTable(xComponent);
			}catch(Exception exc){
				System.out.println("Exception durant la lecture des tables : " + exc.getMessage());
			}
			
			// fermeture
			OOoUtils.closeOrDisposeInstance(xComponent);
			System.exit(0);
		}
	}
	
	/**
	 * Méthode permettant d'afficher le contenu textuel présent
	 * dans le xComponent passé en entrée
	 * 
	 * @param xComponent Le XComponent dont on souhaite afficher
	 * le contenu textuel
	 */
	public static void readText(XComponent xComponent){
		XTextDocument xTextDocument = OOoUtils.getInterface(XTextDocument.class, xComponent);
		XText xText = xTextDocument.getText();
		System.out.println(xText.getString());
	}
	
	/**
	 * Méthode permettant d'afficher le contenu des tables présentes dans
	 * le xComponent passé en entrée
	 * 
	 * @param xComponent Le XComponent dont on souhaite afficher le contenu
	 * des tables
	 * @throws Exception
	 */
	public static void readTable(XComponent xComponent) throws Exception{
		XTextDocument xTextDocument = OOoUtils.getInterface(XTextDocument.class, xComponent);
		// Récupération de l'interface XTextTableSupplier via le xTextDocument
		XTextTablesSupplier xTablesSupplier = OOoUtils.getInterface( XTextTablesSupplier.class, xTextDocument);
		// Récupération des tables du document
		XNameAccess xNamedTables = xTablesSupplier.getTextTables(); 
		// Récupération de l'objet de parcours de ces tables
		XIndexAccess xIndexedTables = OOoUtils.getInterface(XIndexAccess.class, xNamedTables);
		int nbTables = xIndexedTables.getCount();
		// parcours des tables		
		for(int i = 0; i < nbTables; i++) { 
			Object table = xIndexedTables.getByIndex(i);
			// Récupération de la table sous la forme d'un XTextTable
			XTextTable xTextTable = OOoUtils.getInterface(XTextTable.class, table);
			// Récupération du nom de la table
			XPropertySet propertyXTextTable = OOoUtils.getInterface(XPropertySet.class, xTextTable);
			String tableName = (String)propertyXTextTable.getPropertyValue("LinkDisplayName");
			// Récupération des colonnes
			XTableColumns xTableColumns = xTextTable.getColumns();
			// Récupération des lignes
			XTableRows xTableRows = xTextTable.getRows();
			int nbColumns = xTableColumns.getCount();
			int nbRows = xTableRows.getCount();
			System.out.println(tableName + " [" + nbRows + " rows / " + nbColumns + " columns]");
			// Récupération du nom des cellules
			String[] cellNames = xTextTable.getCellNames();
			int row = 0;
			int column = 0;
			// Parcours des cellules et affichage de leur contenu
			for(String cellName : cellNames){
				XText xTextCell = OOoUtils.getInterface(XText.class, xTextTable.getCellByName(cellName));
				System.out.print(xTextCell.getString() + "\t");
				column++;
				if(column == nbColumns){
					row++;
					column = 0;
					System.out.println();
				}
			}
			
			System.out.println();
		}
	}
}
