package fr.test.utils;

/**
 * Enuméré caractérisant le type des documents OOo
 * pouvant être produits
 * 
 * @author Sylvain Saurel
 *
 */
public enum DocumentType {
	/** Document Calc */
	CALC("scalc"),
	/** Document Draw */
	DRAW("sdraw"),
	/** Document Impress */
	IMPRESS("simpress"),
	/** Document Writer */
	WRITER("swriter");
	
	/** Début du chemin de valeur associée au type */
	private static String START_PATH = "private:factory/";
	/** Nom associé au type */
	private String name;
	
	/**
	 * Constructeur
	 * 
	 * @param name Nom associé
	 */
	private DocumentType(String name) {
		this.name = name;
	}
	
	/**
	 * Renvoie le chemin associé au type courant
	 * 
	 * @return
	 */
	public String getValue(){
		return START_PATH + name;
	}
}
