package fr.test.utils;

/**
 * Classe contenant les données du Chart
 * 
 * @author Sylvain Saurel
 *
 */
public class SampleData{
	
	/** Données */
	private double[][] data;
	/** Nom des colonnes */
	private String[] columnDescriptions;
	/** Nom des lignes */
	private String[] rowDescriptions;
	
	/**
	 * Constructeur
	 */
	public SampleData(){
		initialize();
	}
	
	/**
	 * Méthode d'initialisation des données
	 * 
	 */
	private void initialize(){
		data = new double[][]{	{85.88, 9, 2.8, 0.54},
								{80.69, 13.5, 4.06, 0.56},
								{77.37, 15.84, 5.24, 0.62},
								{71.11, 20.06, 6.62, 0.75}};
		columnDescriptions = new String[]{"Internet Explorer", "Firefox", "Safari", "Opera"};
		rowDescriptions = new String[]{"2005", "2006", "2007", "2008"};
	}

	/**
	 * Accesseur aux données
	 * 
	 * @return
	 */
	public double[][] getData() {
		return data;
	}

	/**
	 * Accesseur au nom des colonnes
	 * 
	 * @return
	 */
	public String[] getColumnDescriptions() {
		return columnDescriptions;
	}

	/**
	 * Accesseur au nom des lignes
	 * 
	 * @return
	 */
	public String[] getRowDescriptions() {
		return rowDescriptions;
	}
}
