package fr.test.utils;

/**
 * Enuméré caractérisant les formats de sauvegarde
 * utilisables
 * 
 * @author Sylvain Saurel
 *
 */
public enum SaveFormat {
	/** Format Doc pour documents Writer */
	DOC("MS Word 97", "doc"),
	/** Format Ods pour documents Calc */
	ODS("StarOffice XML (Calc)", "ods"),
	/** Format Odg pour documents Draw */
	ODG(null, "odg"),
	/** Format Odt pour documents Writer */
	ODT("StarOffice XML (Writer)", "odt"),
	/** Format PDF pour documents Writer */
	PDF("writer_pdf_Export", "pdf"),
	/** Format Sda pour documents Draw */
	SDA("StarDraw 5.0", "sda"),
	/** Format Xls pour documents Calc */
	XLS("MS Excel 97", "xls");

	/** Nom du filtre OOo associé au format (<code>null</code> si non nécessaire)*/
	private String filterName;
	/** Extension associé au format */
	private String extension;
	
	/**
	 * Constructeur
	 * 
	 * @param filterName Nom du filtre OOo associé
	 * @param extension Extension pour le format
	 */
	private SaveFormat(String filterName, String extension) {
		this.filterName = filterName;
		this.extension = extension;
	}
	
	/**
	 * Accesseur au nom OOo du filtre associé
	 * au format courant
	 * 
	 * @return
	 */
	public String getFilterName() {
		return filterName;
	}

	/**
	 * Accesseur à l'extension associée
	 * au format courant
	 * 
	 * @return
	 */
	public String getExtension() {
		return extension;
	}	
		
}
