package fr.test.utils;

import java.awt.Color;
import java.util.Random;

/**
 * Classe de méthodes utilitaires
 * 
 * @author Sylvain Saurel
 *
 */
public class Utils {

	/** Random statique */
	private static Random random = new Random();
	
	/**
	 * Constructeur privé car classe utilisée
	 * seulement en contexte statique
	 */
	private Utils(){
	}
	
	/**
	 * Renvoie la valeur entière correspondante à la couleur
	 * passée en entrée
	 * 
	 * @param color Couleur sous forme d'un objet Color
	 * @return Valeur entière correspondante, couleur blanche
	 * par défaut
	 */
	public static Integer ColorToIntegerValue(Color color){
		Integer hexValue = new Integer(0xffffff);
		
		if(color != null){
			hexValue = new Integer(color.getRGB() &  0x00ffffff);
		}
		
		return hexValue;
	}
	
	/**
	 * Méthode renvoyant un nombre aléatoire de type double
	 * 
	 * @return Le double aléatoire généré
	 */
	public static double getRandomDouble(){
		return (random.nextInt() % 1000) * random.nextDouble();
	} 
}
