#include <iostream>

using namespace std;

#include <unistd.h>
#include <signal.h>

void gestionnaire(int numero)
{
	cout << "Signal recu: " << strsignal(numero) << endl;
}

int main()
{
	// Mise en place du gestionnaire	
	if(signal(SIGTSTP, gestionnaire) == SIG_ERR)
	{
		cerr << "Impossible d'installer le gestionnaire" << endl;
		return 1;
	}
	siginterrupt(SIGTSTP, 0);
		
	cout << "Gestionnaire en place" << endl;
	cout << "Ctrl-C pour arreter" << endl;
	
	char c;
	int fd = 0 ; // stdin
	while(1)
	{
		read(fd, &c, sizeof(c));
		if(c == 'q')
		{
			cout << "Fin du programme" << endl;
			return 0;
		}
		else
		{
			cout << "Echo: " << c << endl;
		}
	}
	
	return 0;
}
