#include <iostream>
using namespace std;

#include <unistd.h>
#include <signal.h>


void gestionnaire_sigtstp(int sig)
{
	cout << "Entree dans le gestionnaire SIGTSTP" << endl;
	cout << "Recu: " << strsignal(sig) << endl;
	sleep(2);
	cout << "Sortie gestionnaire SIGTSTP" << endl;
}

void gestionnaire_sigquit(int sig)
{
	cout << "Entree dans le gestionnaire SIGTSTP" << endl;
	cout << "Recu: " << strsignal(sig) << endl;
	sleep(2);
	cout << "Sortie gestionnaire SIGQUIT" << endl;
}


int main()
{
	struct sigaction action;
	
	// Configuration pour SIGTSTP
	action.sa_handler = gestionnaire_sigtstp;
	sigemptyset(&action.sa_mask);
	sigaddset(&action.sa_mask, SIGINT);
	sigaddset(&action.sa_mask, SIGQUIT);
	action.sa_flags = SA_RESTART;
	if(sigaction(SIGTSTP, &action, 0) != 0)
	{
		cerr << "Impossible installer gestionnaire SIGTSTP" << endl;
	}
	
	// Configuration pour SIGQUIT
	action.sa_handler = gestionnaire_sigquit;
	sigemptyset(&action.sa_mask);
	sigaddset(&action.sa_mask, SIGINT);
	sigaddset(&action.sa_mask, SIGTSTP);
	action.sa_flags = SA_RESTART|SA_ONESHOT;
	if(sigaction(SIGQUIT, &action, 0) != 0)
	{
		cerr << "Impossible installer gestionnaire SIGTSTP" << endl;
	}

	while(1)
		pause();
	return 0;
}
