package com.programmez.opengl.exercice1;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;

import javax.microedition.khronos.opengles.GL10;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.opengl.GLUtils;

class GLCube {
   private final IntBuffer mVertexBuffer;
   private final IntBuffer mTextureBuffer;

   
   public GLCube() {
      
      int one = 65536;
      int half = one / 2;
      int vertices[] = { 
            // Front face
            -half, -half, half, half, -half, half,
            -half, half, half, half, half, half,
            // Back face
            -half, -half, -half, -half, half, -half,
            half, -half, -half, half, half, -half,
            // Left face
            -half, -half, half, -half, half, half,
            -half, -half, -half, -half, half, -half,
            // Right face
            half, -half, -half, half, half, -half,
            half, -half, half, half, half, half,
            // Top face
            -half, half, half, half, half, half,
            -half, half, -half, half, half, -half,
            // Bottom face
            -half, -half, half, -half, -half, -half,
            half, -half, half, half, -half, -half, };

      int textureCoordinates[] = {
            0, one, one, one, 0, 0, one, 0,
            one, one, one, 0, 0, one, 0, 0,
            one, one, one, 0, 0, one, 0, 0,
            one, one, one, 0, 0, one, 0, 0,
            one, 0, 0, 0, one, one, 0, one,
            0, 0, 0, one, one, 0, one, one, };
      
      ByteBuffer vBuffer = ByteBuffer.allocateDirect(vertices.length * 4);
      vBuffer.order(ByteOrder.nativeOrder());
      mVertexBuffer = vBuffer.asIntBuffer();
      mVertexBuffer.put(vertices);
      mVertexBuffer.position(0);
      
      ByteBuffer tBuffer = ByteBuffer.allocateDirect(textureCoordinates.length * 4);
      tBuffer.order(ByteOrder.nativeOrder());
      mTextureBuffer = tBuffer.asIntBuffer();
      mTextureBuffer.put(textureCoordinates);
      mTextureBuffer.position(0);
      
   }
   

   public void draw(GL10 gl) { 
      gl.glVertexPointer(3, GL10.GL_FIXED, 0, mVertexBuffer);
      gl.glTexCoordPointer(2, GL10.GL_FIXED, 0, mTextureBuffer);
      
      gl.glNormal3f(0, 0, 1);
      gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 0, 4);
      gl.glNormal3f(0, 0, -1);
      gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 4, 4);

      gl.glNormal3f(-1, 0, 0);
      gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 8, 4);
      gl.glNormal3f(1, 0, 0);
      gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 12, 4);

      gl.glNormal3f(0, 1, 0);
      gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 16, 4);
      gl.glNormal3f(0, -1, 0);
      gl.glDrawArrays(GL10.GL_TRIANGLE_STRIP, 20, 4);
   }
   
   
   static void loadTexture(GL10 gl, Context context, int resource) {
      Bitmap bmp = BitmapFactory.decodeResource(
            context.getResources(), resource);
      GLUtils.texImage2D(GL10.GL_TEXTURE_2D, 0, bmp, 0);
      gl.glTexParameterx(GL10.GL_TEXTURE_2D,
            GL10.GL_TEXTURE_MIN_FILTER, GL10.GL_LINEAR);
      gl.glTexParameterx(GL10.GL_TEXTURE_2D,
            GL10.GL_TEXTURE_MAG_FILTER, GL10.GL_LINEAR);
      bmp.recycle();
   }
}

