package com.programmez.opengl.exercice2;

import static android.opengl.GLES10.GL_FASTEST;
import static android.opengl.GLES10.GL_PERSPECTIVE_CORRECTION_HINT;
import static android.opengl.GLES10.glClear;
import static android.opengl.GLES10.glDepthFunc;
import static android.opengl.GLES10.glDisable;
import static android.opengl.GLES10.glEnable;
import static android.opengl.GLES10.glEnableClientState;
import static android.opengl.GLES10.glFrustumf;
import static android.opengl.GLES10.glHint;
import static android.opengl.GLES10.glLightfv;
import static android.opengl.GLES10.glLoadIdentity;
import static android.opengl.GLES10.glMaterialfv;
import static android.opengl.GLES10.glMatrixMode;
import static android.opengl.GLES10.glRotatef;
import static android.opengl.GLES10.glViewport;

import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.opengles.GL10;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.opengl.GLU;

public class TerrainRenderer implements GLSurfaceView.Renderer {
	private final Context context;

	private final GLTerrain terrain = new GLTerrain();
	private float mAngleX;
	private float mAngleY;

	public float getmAngleX() {
		return mAngleX;
	}

	public void setmAngleX(float mAngleX) {
		this.mAngleX = mAngleX;
	}

	public float getmAngleY() {
		return mAngleY;
	}

	public void setmAngleY(float mAngleY) {
		this.mAngleY = mAngleY;
	}

	TerrainRenderer(Context context) {
		this.context = context;
	}

	public void onSurfaceCreated(GL10 gl, EGLConfig config) {

		glDisable(GL10.GL_DITHER);
		glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_FASTEST);

		// Define the lighting
		float lightAmbient[] = new float[] { 0.2f, 0.2f, 0.2f, 1 };
		float lightDiffuse[] = new float[] { 1, 1, 1, 1 };
		float[] lightPos = new float[] { 1, -30, 1, 1 };
		glEnable(GL10.GL_LIGHTING);
		glEnable(GL10.GL_LIGHT0);
		glLightfv(GL10.GL_LIGHT0, GL10.GL_AMBIENT, lightAmbient, 0);
		glLightfv(GL10.GL_LIGHT0, GL10.GL_DIFFUSE, lightDiffuse, 0);
		glLightfv(GL10.GL_LIGHT0, GL10.GL_POSITION, lightPos, 0);

		float matAmbient[] = new float[] { 1, 1, 1, 1 };
		float matDiffuse[] = new float[] { 1, 1, 1, 1 };
		glMaterialfv(GL10.GL_FRONT_AND_BACK, GL10.GL_AMBIENT, matAmbient, 0);
		glMaterialfv(GL10.GL_FRONT_AND_BACK, GL10.GL_DIFFUSE, matDiffuse, 0);

		glEnable(GL10.GL_DEPTH_TEST);
		glDepthFunc(GL10.GL_LEQUAL);
		glEnableClientState(GL10.GL_VERTEX_ARRAY);
		glEnableClientState(GL10.GL_NORMAL_ARRAY);
		glEnableClientState(GL10.GL_TEXTURE_COORD_ARRAY);
		glEnable(GL10.GL_TEXTURE_2D);

		terrain.loadTexture(gl, context);
		terrain.loadTerrain(gl, context);
	}

	public void onSurfaceChanged(GL10 gl, int width, int height) {
		glViewport(0, 0, width, height);
		glMatrixMode(GL10.GL_PROJECTION);
		glLoadIdentity();
		float ratio = (float) width / height;
		glFrustumf(-ratio, ratio, -1, 1, 1, 300);
		glMatrixMode(GL10.GL_MODELVIEW);
	}

	public void onDrawFrame(GL10 gl) {
		glDisable(GL10.GL_DITHER);
		glClear(GL10.GL_COLOR_BUFFER_BIT | GL10.GL_DEPTH_BUFFER_BIT);
		
		glMatrixMode(GL10.GL_MODELVIEW);
		glLoadIdentity();		
		GLU.gluLookAt(gl, 0, 30, 30, 0f, 0f, 0f, 0f, 1.0f, 0.0f);
		
		glRotatef( (mAngleX), 1, 0, 0);
		glRotatef( (mAngleY), 0, 1, 0);
		
		terrain.draw(gl);
	}
}
