package com.programmez.opengl.exercice2;

import android.content.Context;
import android.opengl.GLSurfaceView;
import android.view.MotionEvent;

public class TerrainSurfaceView extends GLSurfaceView{
	TerrainRenderer mRenderer;
	private final float TOUCH_SCALE_FACTOR = 180.0f / 320;
	private final float TRACKBALL_SCALE_FACTOR = 36.0f;
	private float mPreviousX = 0;
	private float mPreviousY = 0;

	public TerrainSurfaceView(Context context) {
		super(context);
		mRenderer = new TerrainRenderer(context);
		setRenderer(mRenderer);
		setRenderMode(GLSurfaceView.RENDERMODE_CONTINUOUSLY);
	}

	@Override
	public boolean onTrackballEvent(MotionEvent e) {
		mRenderer.setmAngleX(mRenderer.getmAngleX() + e.getX()
				* TRACKBALL_SCALE_FACTOR);
		mRenderer.setmAngleY(mRenderer.getmAngleY() + e.getY()
				* TRACKBALL_SCALE_FACTOR);
		return true;
	}

	@Override
	public boolean onTouchEvent(MotionEvent e) {
		float x = e.getX();
		float y = e.getY();
		switch (e.getAction()) {
		case MotionEvent.ACTION_MOVE:
			float dx = x - mPreviousX;
			float dy = y - mPreviousY;
			mRenderer.setmAngleX(mRenderer.getmAngleX() + dy
					* TOUCH_SCALE_FACTOR);
			mRenderer.setmAngleY(mRenderer.getmAngleY() + dx
					* TOUCH_SCALE_FACTOR);
		}
		mPreviousX = x;
		mPreviousY = y;
		return true;
	}
}
