using System;
using System.Drawing;
using SdlDotNet;
using SdlDotNet.Sprites;

namespace Pong
{
	public class Pong
	{
		Sprite ball = new Sprite(new Surface("Ball.PNG"));
		int ballSpeedX = 1;
		int ballSpeedY = 1;

		public Pong()
		{
			Video.SetVideoModeWindow(300, 200);
			Events.Tick += new TickEventHandler(Events_Tick);

			ball.Surface.TransparentColor = System.Drawing.Color.Magenta;
		}

		private void Events_Tick(object sender, TickEventArgs e)
		{
			// Update location of the ball
			ball.X += ballSpeedX;
			ball.Y += ballSpeedY;

			// Bounce the ball
			if(ball.Right > Video.Screen.Width)
				ballSpeedX *= -1;
			if(ball.Left < 0)
				ballSpeedX *= -1;
			if(ball.Top < 0)
				ballSpeedY *= -1;
			if(ball.Bottom > Video.Screen.Height)
				ballSpeedY *= -1;

			// Clear the screen
			Video.Screen.Fill(Color.Black);

			// Draw the ball
			ball.Render(Video.Screen);

			// Update the screen
			Video.Screen.Update();
		}

		public void Run()
		{	
			Events.Run();
		}

		[STAThread]
		public static void Main()
		{
			Pong pong = new Pong();
			pong.Run();
		}
	}
}
