package com.programmez.jmf;

import javax.media.*;
import javax.media.rtp.*;
import javax.media.rtp.event.*;

import javax.swing.JFrame;
import java.net.InetAddress;

/**
 * Lire un flux audio
 *
 * @author Eric CHAYSINH
 */
public class Receiver implements ReceiveStreamListener {

    /**
     * Constructeur
     */
    public Receiver() {}

    /**
     * Affichage d'une fentre symbolique
     */
    public void buildGUI() {
        JFrame mainFrame = new JFrame();

        mainFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        mainFrame.setTitle("Programmez! - JMF (RECEIVER)");
        mainFrame.setSize(300, 200);

        mainFrame.setVisible(true);
    }

    /**
     * Initialisation
     */
    public void init() {
        /* Cration du gestionnaire de flux RTP */
        RTPManager manager = RTPManager.newInstance();

        try {
            /* Configuration de l'adresse locale */
            SessionAddress localAddress = new SessionAddress(InetAddress.getByName(Constants.RECEIVER_IP), Constants.RECEIVER_PORT);
            manager.initialize(localAddress);

            /* Configuration de l'adresse de l'metteur */
            SessionAddress sourceAddress = new SessionAddress(InetAddress.getByName(Constants.SENDER_IP), Constants.SENDER_PORT);
            manager.addTarget(sourceAddress);
        }
        catch (Exception e) {
            e.printStackTrace();
        }

        /* Abonnement aux evenements de reception de flux */
        manager.addReceiveStreamListener(this);
    }

    /**
     * Jouer le son lors de la reception d'un flux
     */
    public void update(ReceiveStreamEvent event) {
        /* Reception d'un flux */
        if (event instanceof NewReceiveStreamEvent) {
            /* Reception d'un flux */
            ReceiveStream stream = event.getReceiveStream();
            try {
                /* Cration d'un Player pour lire le flux */
                Player player = Manager.createRealizedPlayer(stream.getDataSource());
                player.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * MAIN
     */
    public static void main(String[] args) {
        Receiver receiver = new Receiver();

        receiver.buildGUI();
        receiver.init();
    }
}

