package com.programmez.jmf;

import javax.media.*;
import javax.media.rtp.*;
import javax.media.protocol.*;

import javax.swing.JFrame;
import java.net.InetAddress;

/**
 * Envoi d'un flux audio captur dans un micro
 *
 * @author Eric CHAYSINH
 */
public class Sender implements ControllerListener {

    /**
     * Gestionnaire de lecture
     */
    private Processor processor = null;

    /**
     * Flux RTP
     */
    private SendStream stream = null;


    /**
     * Constructeur
     */
    public Sender() {}


    /**
     * Affichage d'une fentre symbolique
     */
    public void buildGUI() {
        JFrame mainFrame = new JFrame();

        mainFrame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        mainFrame.setTitle("Programmez! - JMF (SENDER)");
        mainFrame.setSize(300, 200);

        mainFrame.setVisible(true);
    }

    /**
     * Initialisation du priphrique
     */
    public void init() {
        try {
            /* Rcuperation du priphrique */
            CaptureDeviceInfo captureDevice = CaptureDeviceManager.getDevice("JavaSound audio capture");

            /* Cration d'un Processor pour capturer le son */
            processor = Manager.createProcessor(captureDevice.getLocator());

            /* Configurer le priphrique */
            while (processor.getState() < Processor.Configured) {
                //Configuration du Processor
                processor.configure();
            }

            /* Configuration du type de donnes  traiter (Fichier WAV) */
            processor.setContentDescriptor(new ContentDescriptor(ContentDescriptor.RAW_RTP));

            /* Abonnement aux evenements de lecture du son */
            processor.addControllerListener(this);

            /* Initialisation de la ressource */
            processor.realize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Initialisation du format de sortie (flux RTP)
     */
    public void initializeOutput() {
        /* Rcuperer la source  envoyer */
        DataSource source = processor.getDataOutput();

        /* Rcuperer le RTPManager */
        RTPManager manager = RTPManager.newInstance();

        try {
            /* Configuration de l'adresse locale */
            SessionAddress localAddress = new SessionAddress(InetAddress.getByName(Constants.SENDER_IP), Constants.SENDER_PORT);
            manager.initialize(localAddress);

            /* Configuration de l'adresse du recepteur */
            SessionAddress destAddress = new SessionAddress(InetAddress.getByName(Constants.RECEIVER_IP), Constants.RECEIVER_PORT);
            manager.addTarget(destAddress);

            /* Envoi du flux RTP */
            SendStream stream = manager.createSendStream(source, 0);
            stream.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void controllerUpdate(ControllerEvent e) {
        // Affichage des evenements recus
//        System.out.println("Event: " + e.getClass().getName());

        /* Fin de l'inialisation de la ressource */
        if (e instanceof RealizeCompleteEvent) {
            initializeOutput();
            processor.start();
        } else if (e instanceof StartEvent) {

        }
    }

    public static void main(String[] args) {
        Sender sender = new Sender();

        sender.buildGUI();
        sender.init();
    }
}