package com.programmez.jmf;

import javax.media.*;

/**
 * Lire un fichier son
 *
 * @author Eric CHAYSINH
 */
public class SoundReader implements ControllerListener {

    /**
     * Le Player pour jouer le son
     */
    private Player player;

    /**
     * Chaine rfrant le fichier  jouer
     */
    private String locatorString = "";

    /**
     * Constructeur
     */
    public SoundReader(String locatorString) {
        this.locatorString = locatorString;
    }

    /**
     * Initialisation
     */
    public void init() {
        try {
            /* Cration d'un Player pour lire le son */
            player = Manager.createPlayer(new MediaLocator(locatorString));

            /* Abonnement aux evenements de lecture du son */
            player.addControllerListener(this);

            /* Initialisation de la ressource */
            player.realize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Lecture du son
     */
    public void play() {
        if (player != null)
            player.start();
    }

    /**
     * Arrt de lecture du son
     */
    public void close() {
        if (player != null)
            player.close();
    }

    /**
     * Evenements de lecture
     */
    public void controllerUpdate(ControllerEvent event) {
        // Affichage des evenements recus
//        System.out.println("Event: " + e.getClass().getName());

        /* Fin de l'inialisation de la ressource */
        if (event instanceof RealizeCompleteEvent) {
            play();
        /* Arrt de l'utilisateur */
        } else if (event instanceof StopByRequestEvent) {
            close();
        /* Fin de la lecture du fichier */
        } else if (event instanceof EndOfMediaEvent) {
            close();
        }
    }

    /**
     * MAIN
     */
    public static void main(String[] args) {
        SoundReader receiver = new SoundReader("file:/C:/Programmez/sample.wav");

        receiver.init();
    }
}
