package com.programmez.jmf;

import javax.media.*;
import javax.media.protocol.*;

import java.io.IOException;

/**
 * Capturer une voix  partir d'un micro
 *
 * @author Eric CHAYSINH
 */
public class VoiceCapture implements ControllerListener {

    /**
     * Priphrique de capture
     */
    private CaptureDeviceInfo captureDevice = null;

    /**
     * Gestionnaire de lecture
     */
    private Processor processor = null;

    /**
     * Gestionnaire d'criture dans un fichier
     */
    private DataSink streamManager = null;

    /**
     * Chaine rfrant le fichier  jouer
     */
    private String locatorString = "file:/C:/Programmez/sample.wav";

    /**
     * Constructeur
     */
    public VoiceCapture() {}

    /**
     * Initialisation du priphrique
     */
    public void init() {
        try {
            /* Rcuperation du priphrique */
            captureDevice = CaptureDeviceManager.getDevice("JavaSound audio capture");

            /* Cration d'un Processor pour capturer le son */
            processor = Manager.createProcessor(captureDevice.getLocator());

            /* Configurer le priphrique */
            while (processor.getState() < Processor.Configured) {
                //Configuration du Processor
                processor.configure();
            }

            /* Configuration du type de donnes  traiter (Fichier WAV) */
			processor.setContentDescriptor(new FileTypeDescriptor(FileTypeDescriptor.WAVE));

            /* Abonnement aux evenements de lecture du son */
            processor.addControllerListener(this);

            /* Initialisation de la ressource */
            while (processor.getState() < Processor.Realized) {
                processor.realize();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /**
     * Initialisation du format de sortie (Fichier)
     */
    public void initializeOutput() {
        try {
            /* Rcuperer la source  crire dans le fichier */
            DataSource source = processor.getDataOutput();

            /* Dfinir le fichier de destination */
            MediaLocator destination = new MediaLocator(locatorString);

            /* Synchroniser source / destination) */
            streamManager = Manager.createDataSink(source, destination);

            /* Ouverture des ressources */
            streamManager.open();

            /* Dmarrage de la synchronisation */
            streamManager.start();

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    /**
     * Dmarrage de la capture
     */
    public void capture() {
        /* Lancer la capture */
        processor.start();
        System.out.println("Dmarrage de l'enregistrement");
        System.out.println(" >> Appuyer sur Entrer terminer l'enregistrement...");

        /* Pause pour la capture */
        try {
            System.in.read();
        }
        catch (IOException e) {
            e.printStackTrace();
        }

        /* Stoper la capture */
        stop();
        System.out.println("Fin de l'enregistrement");
    }

    /**
     * Arrt de la capture
     */
    public void stop() {
        processor.stop();
    }

    public void close() {
        /* Fermeture du lien avec le priphrique */
        processor.close();

        /* Fermeture de la synchronisation priphrique / fichier */
        streamManager.close();
    }


    /**
     * Evenements de capture
     */
    public void controllerUpdate(ControllerEvent e) {
        // Affichage des evenements recus
//        System.out.println("Event: " + e.getClass().getName());

        /* Fin de l'inialisation de la ressource */
        if (e instanceof RealizeCompleteEvent) {
            initializeOutput();
            capture();
        /* Arrt de la capture */
        } else if (e instanceof StopByRequestEvent) {
            close();
        }
    }

    /**
     * MAIN
     */
    public static void main(String[] args) {
        VoiceCapture capture = new VoiceCapture();

        capture.init();

    }
}