package com.programmez.android.dictaphone;

import java.io.File;
import java.io.IOException;

import android.app.Activity;
import android.content.Intent;
import android.media.MediaRecorder;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import android.widget.Button;

/**
 * Dictaphone Android pour Programmez!
 * @author Damien Guignard et Julien Chable
 */
public class Dictaphone extends Activity {

	MediaRecorder mediaRecorder;
	File fichierEnregistre = null;

	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.main);
		mediaRecorder = new MediaRecorder();
		Button startRecording = (Button)findViewById(R.id.debutEnregistrement);
		Button stopRecording = (Button)findViewById(R.id.finEnregistrement);

		startRecording.setOnClickListener(new View.OnClickListener(){
			public void onClick(View v) {
				
				if (fichierEnregistre == null) {
					File sampleDir = Environment.getExternalStorageDirectory();
					try { 
						fichierEnregistre = File.createTempFile("Enregistrement", ".amr", sampleDir);
					} catch (IOException e) {
						// Il faudra apprendre  faire un traitement l dessus 
						return;
					}
				}
				mediaRecorder = new MediaRecorder();
				mediaRecorder.setAudioSource(MediaRecorder.AudioSource.MIC);
				mediaRecorder.setOutputFormat(MediaRecorder.OutputFormat.THREE_GPP);
				mediaRecorder.setAudioEncoder(MediaRecorder.AudioEncoder.AMR_NB);
				mediaRecorder.setOutputFile(fichierEnregistre.getAbsolutePath());
				mediaRecorder.prepare();
				mediaRecorder.start(); // On commence l'enregistrement
			}
		});
		stopRecording.setOnClickListener(new View.OnClickListener(){
			public void onClick(View v) {
				mediaRecorder.stop();	// On arrte l'enregistrement
				mediaRecorder.release();
				
				// A noter qu'avec un ContentResolver on pourrait ajouter ce mdia  la librairie 
				// et notifier les applications dpendantes via un  sendBroadcast(new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE, uri));
			}
		});
	}
}
