using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO.Ports;

namespace DemoSerialPort
{
	public partial class Form1 : Form
	{
		private SerialPort serialport;

		public Form1()
		{
			InitializeComponent();
			textBox1.Text = "COM1: ferm" + Environment.NewLine;
		}
		
		// bouton ouvrir
		private void button1_Click(object sender, EventArgs e)
		{
			serialport = new SerialPort("COM1", 9600);
			serialport.Parity = Parity.None;
			serialport.StopBits = StopBits.One;
			serialport.DataBits = 8;
			serialport.Handshake = Handshake.None;
			serialport.RtsEnable = true;
			serialport.DtrEnable = true;
			serialport.NewLine = "\r";
			serialport.DataReceived += OnSerialDataReceived;
			serialport.ErrorReceived += OnSerialErrorReceived;
			try
			{
				serialport.Open();
				button1.Enabled = false;
				button2.Enabled = true;
				button3.Enabled = true;
				button4.Enabled = true;
				textBox1.Text = "COM1: ouvert" + Environment.NewLine;
			}
			catch
			{
				textBox1.Text = "Impossible d'ouvrir COM1:" + Environment.NewLine;
			}
		}

		// Bouton fermer
		private void button2_Click(object sender, EventArgs e)
		{
			if (serialport == null || !serialport.IsOpen)
				return;

			serialport.Close();
			serialport = null;
			button1.Enabled = true;
			button2.Enabled = false;
			button3.Enabled = false;
			button4.Enabled = false;
			textBox1.Text = "COM1: ferm" + Environment.NewLine ;
		}

		// Bouton 'AT'
		private void button3_Click(object sender, EventArgs e)
		{
			String commande = "at";
			SendCommande(commande);
		}

		// Bouton ATI3
		private void button4_Click(object sender, EventArgs e)
		{
			String commande = "ati3";
			SendCommande(commande);
		}

		private void SendCommande(String commande)
		{
			serialport.WriteLine(commande);
		}

		private void OnSerialDataReceived(Object sender, SerialDataReceivedEventArgs args)
		{
			try
			{
				while (serialport.BytesToRead != 0)
				{
					String s = serialport.ReadLine();

					s = s.Replace("\r", "");
					s = s.Replace("\n", "");
					textBox1.AppendText(s + Environment.NewLine);
				}
			}
			catch { }
		}

		private void OnSerialErrorReceived(Object sender, SerialErrorReceivedEventArgs args)
		{
			textBox1.AppendText("Error de transmission srie"
			+ Environment.NewLine
			+ "Veuiller fermer le port");
		}

		private void Form1_FormClosing(object sender, FormClosingEventArgs e)
		{
			if (serialport != null && serialport.IsOpen)
			{
				MessageBox.Show("Veuillez fermer le port avant de quitter");
				e.Cancel = true;
			}
		}
	}
}