using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;
using System.Net;
using System.Threading;

namespace GetImageThread
{
	public partial class Form1 : Form
	{
		private const int length = 1000;
		private HttpWebRequest hwr;
		private WebResponse wr;
		private Stream st;
		private FileStream fs;
		private int lu;
		private int compteur;
		private byte[] buffer = new byte[length];

		private delegate void PutOnTextBox(String texte);
		private PutOnTextBox PutString;

		public Form1()
		{
			InitializeComponent();
		}

		private void CreateAllStream()
		{
			hwr = (HttpWebRequest)WebRequest.Create(
				"http://www.programmez.com/getLastCover.php");

			wr = hwr.GetResponse();
			st = wr.GetResponseStream();

			fs = new FileStream("C:\\temp\\image.jpg",
				FileMode.Create,
				FileAccess.Write);
		}

		private void ThreadWorkerWait()
		{
			CreateAllStream();
			textBox1.Text = "";
			compteur = 0;

			while (true)
			{
				IAsyncResult ar = st.BeginRead(buffer, 0, length, null, null);
				if (ar.CompletedSynchronously)
				{
					compteur += 1;		
					lu = st.EndRead(ar);
					if (lu == 0)
						break;
					textBox1.Invoke(PutString,
						new Object[] {"Synchrone lus: "
						+ lu + Environment.NewLine});
				}
				else
				{
					// Attendre que la fin de la 
					// lecture soit signale
					ar.AsyncWaitHandle.WaitOne();
					compteur += 1;
					lu = st.EndRead(ar);
					if (lu == 0)
						break;
					textBox1.Invoke(PutString,
						new Object[] {"Asynchrone lus: "
						+ lu + Environment.NewLine});
				}
				fs.Write(buffer, 0, lu);
			}

			textBox1.Invoke(PutString,
				new Object[] {Environment.NewLine
						+ compteur + " oprations de lecture"});
			fs.Close();
			st.Close();
		}

		private void ThreadWorkerPolling()
		{
			CreateAllStream();
			textBox2.Text = "";
			compteur = 0;

			while (true)
			{
				IAsyncResult ar = st.BeginRead(buffer, 0, length, null, null);
				if (ar.CompletedSynchronously)
				{
					compteur += 1;
					lu = st.EndRead(ar);
					if (lu == 0)
						break;
					textBox2.Invoke(PutString,
						new Object[] {"Synchrone lus: "
						+ lu + Environment.NewLine});
				}
				else
				{
					// Attendre que la fin de la 
					// lecture soit signale
					while (!ar.IsCompleted)
					{
						System.Threading.Thread.Sleep(10);
					}
					compteur += 1;
					lu = st.EndRead(ar);
					if (lu == 0)
						break;
					textBox2.Invoke(PutString,
						new Object[] {"Asynchrone lus: "
						+ lu + Environment.NewLine});
				}
				fs.Write(buffer, 0, lu);
			}

			textBox2.Invoke(PutString,
				new Object[] {Environment.NewLine
						+ compteur + " oprations de lecture"});
			fs.Close();
			st.Close();
		}


		private void button1_Click(object sender, EventArgs e)
		{
			PutString = new PutOnTextBox(textBox1.AppendText);
			Thread t = new Thread(ThreadWorkerWait);
			t.Start();
		}

		private void button2_Click(object sender, EventArgs e)
		{
			PutString = new PutOnTextBox(textBox2.AppendText);
			Thread t = new Thread(ThreadWorkerPolling);
			t.Start();
		}
	}
}