﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;


using System.ServiceModel;
using System.ServiceModel.Description;
using Microsoft.ServiceBus;
using Microsoft.WindowsAzure.ServiceRuntime;
using HotelApplication.ViewModel;
using System.Net;
using System.IO;

namespace HotelApplication
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        
        private ServiceHost hostServiceFacturation=null;

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            this.DataContext = FacturationViewModelFactory.CurrentViewModel;
        }




        private void butExposeServiceHotelier_Click(object sender, RoutedEventArgs e)
        {
            Uri uriSbFacturation = ServiceBusEnvironment.CreateServiceUri("sb", 
                HotelApplication.Properties.Settings.Default.ServiceNamespace,
                HotelApplication.Properties.Settings.Default.ServicePath);

            hostServiceFacturation = new ServiceHost(typeof(Services.FacturationExterneService), uriSbFacturation);
            hostServiceFacturation.Open();
        }



        private void CreateHostParProgramation()
        {
            if (hostServiceFacturation != null)
            {
                if (MessageBox.Show("Le service est déjà exposé.\r\nVoulez vous l'arréter ?", "Arret ?", MessageBoxButton.YesNo, MessageBoxImage.Question, MessageBoxResult.No) == MessageBoxResult.Yes)
                {
                    hostServiceFacturation.Close();
                    hostServiceFacturation = null;
                }
                return;
            }

            // recupération de la configuration 
            string servicePath = HotelApplication.Properties.Settings.Default.ServicePath;
            string serviceNamespace = HotelApplication.Properties.Settings.Default.ServiceNamespace;
            string issuerName = HotelApplication.Properties.Settings.Default.IssuerName;
            string issuerSecret = HotelApplication.Properties.Settings.Default.IssuerSecret;

            // creation d'une URI pour le service bus

            Uri uriSbFacturation = ServiceBusEnvironment.CreateServiceUri("sb", serviceNamespace, servicePath);


            // Creation du behaviour pour les informations d'authentification vis a vis d'azure
            TransportClientEndpointBehavior sharedSecretServiceBusCredential = new TransportClientEndpointBehavior();
            sharedSecretServiceBusCredential.CredentialType = TransportClientCredentialType.SharedSecret;
            sharedSecretServiceBusCredential.Credentials.SharedSecret.IssuerName = issuerName;
            sharedSecretServiceBusCredential.Credentials.SharedSecret.IssuerSecret = issuerSecret;

            // Creation du Service Host 
            hostServiceFacturation = new ServiceHost(typeof(Services.FacturationExterneService), uriSbFacturation);
            ContractDescription contractDescription = ContractDescription.GetContract(typeof(Services.IFacturationExterneContract), typeof(Services.FacturationExterneService));
            ServiceEndpoint serviceEndPoint = new ServiceEndpoint(contractDescription);
            serviceEndPoint.Address = new EndpointAddress(uriSbFacturation);
            serviceEndPoint.Binding = new NetTcpRelayBinding(); // utilisation du binding relay vers Azure/AppFabric
            serviceEndPoint.Behaviors.Add(sharedSecretServiceBusCredential);
            hostServiceFacturation.Description.Endpoints.Add(serviceEndPoint);

            // activation du Host
            hostServiceFacturation.Open();
        }

        private void butNouvelleReservation_Click(object sender, RoutedEventArgs e)
        {

            string req = string.Format("https://programmez-article-appfabric.servicebus.windows.net/GestionRestaurant/Reservation/Reserver?nomResa={0}&nbPersonnes={1}&dateEtHeure=2010-12-31T19:00:00&remarque={3}",
                txtResaName.Text, txtNb.Text, "2010-12-31T19:00:00", txtRemarques.Text);
            HttpWebRequest serviceRestRequest = (HttpWebRequest)HttpWebRequest.Create(req);
            serviceRestRequest.Method = "GET";
            serviceRestRequest.BeginGetResponse( result =>
                {
                    HttpWebResponse resaResponse = serviceRestRequest.EndGetResponse(result) as HttpWebResponse;
                    Stream str = resaResponse.GetResponseStream();
                    StreamReader sr = new StreamReader(str);
                    string message = sr.ReadToEnd();
                    sr.Close();
                    MessageBox.Show(message);
                },null);


        }

      
    }
}
