﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;

namespace HotelApplication.Model
{
    public class LigneFacturation : INotifyPropertyChanged
    {

        int _room;

        public int Room
        {
            get { return _room; }
            set { _room = value; RaisePropertyChangedEvent("Room");  }
        }

        string _description;

        public string Description
        {
            get { return _description; }
            set { _description = value; RaisePropertyChangedEvent("Description"); }
        }

        decimal _price;

        public decimal Price
        {
            get { return _price; }
            set { _price = value; RaisePropertyChangedEvent("Price"); }
        }

        decimal _vatRate;

        public decimal VatRate
        {
            get { return _vatRate; }
            set { _vatRate = value; RaisePropertyChangedEvent("VatRate"); }
        }

        decimal _vat;

        public decimal Vat
        {
            get { return _vat; }
            set { _vat = value; RaisePropertyChangedEvent("Vat"); }
        }

        #region Implementation de INotifyPropertyChanged

        void RaisePropertyChangedEvent(string propertyName)
        {
            if (PropertyChanged != null)
                PropertyChanged(this, new PropertyChangedEventArgs(propertyName));
        }

        public event PropertyChangedEventHandler PropertyChanged;
        #endregion
    }
}
