﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;

namespace HotelApplication.Services
{
    [ServiceBehavior(Name = "FacturationExterneService", 
        Namespace = "http://hotelapplication.sablefin.com/ServiceModel/FacturationExterne/")]
    public class FacturationExterneService : IFacturationExterneContract
    {
        public string CheckCustomer(long roomNumber, string customerName)
        {
            if (roomNumber < 2000)  // verification de la validité de la chambre :) (règle métier !)
            { 
                Guid jeton = Guid.NewGuid();
                ViewModel.FacturationViewModelFactory.CurrentViewModel.JetonAutorisations.Add(jeton);
                return jeton.ToString();
            }
            return string.Empty;
        }

        public string AddBillingLine(string customerToken, string description, 
                        decimal price, decimal vatRate, decimal vat)
        {
            Guid jeton = new Guid(customerToken);
            if (ViewModel.FacturationViewModelFactory.CurrentViewModel.JetonAutorisations.Contains(jeton))
            {
                ViewModel.FacturationViewModelFactory.CurrentViewModel.JetonAutorisations.Remove(jeton);
                ViewModel.FacturationViewModelFactory.CurrentViewModel.NouvelleLigneFacture(description, price, vatRate, vat);
                return "Ok";
            }
            return "ERREUR : JETON INVALIDE";
        }
    }

}
