﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;

namespace HotelApplication.Services
{

    [ServiceContract(Name = "IFacturationExterneContract", 
        Namespace = "http://hotelapplication.sablefin.net/ServiceModel/FacturationExterne/")]
    public interface IFacturationExterneContract
    {
        [OperationContract]
        string  CheckCustomer(long roomNumber, string customerName);

        // correspondant au jeton d'autorisation
        [OperationContract]
        string AddBillingLine(string customerToken, string description, 
                        decimal price, decimal vatRate, decimal vat);
    }

    public interface IFacturationExterneChannel : IFacturationExterneContract, IClientChannel { }
}




