﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.ServiceBus;
using System.ServiceModel;
using System.Diagnostics;
using HotelApplication.Services;

namespace MagasinApplication
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        Uri uriServiceFacturation=null;

        void CreateUri()
        {
            // recupération de la configuration 
            string servicePath = MagasinApplication.Properties.Settings.Default.ServicePath;
            string serviceNamespace = MagasinApplication.Properties.Settings.Default.ServiceNamespace;
            string issuerName = MagasinApplication.Properties.Settings.Default.IssuerName;
            string issuerSecret = MagasinApplication.Properties.Settings.Default.IssuerSecret;

            // creation d'une URI pour le service bus
            uriServiceFacturation = ServiceBusEnvironment.CreateServiceUri("sb", serviceNamespace, servicePath);
        }

        private void butCheckCustomer_Click(object sender, RoutedEventArgs e)
        {
            txbResultatFacturation.Text = string.Empty;
           
            ChannelFactory<IFacturationExterneChannel> channelFactory = null ;
            IFacturationExterneChannel channelServiceFacturation = null;
            try
            {
                TransportClientEndpointBehavior sharedSecretServiceBusCredential = new TransportClientEndpointBehavior();
                sharedSecretServiceBusCredential.CredentialType = TransportClientCredentialType.SharedSecret;
                sharedSecretServiceBusCredential.Credentials.SharedSecret.IssuerName = MagasinApplication.Properties.Settings.Default.IssuerName;
                sharedSecretServiceBusCredential.Credentials.SharedSecret.IssuerSecret = MagasinApplication.Properties.Settings.Default.IssuerSecret;

                channelFactory = new ChannelFactory<IFacturationExterneChannel>(new NetTcpRelayBinding(),new EndpointAddress(uriServiceFacturation));
                channelFactory.Endpoint.Behaviors.Add(sharedSecretServiceBusCredential);
                
                channelServiceFacturation = channelFactory.CreateChannel();
                channelServiceFacturation.Open();

                string jeton = channelServiceFacturation.CheckCustomer(long.Parse(txtRoom.Text), txtCustomerName.Text);
                txtAuthorization.Text = jeton;
                txtDescription.Focus();
            }
            catch (Exception ex)
            {
                Debug.WriteLine(string.Format("Error sending: {0}\r\n{1}", ex.Message, ex.StackTrace));
            }
            finally
            {
                if (channelServiceFacturation != null)
                    CloseCommunicationObject(channelServiceFacturation);
                if (channelFactory != null)
                    CloseCommunicationObject(channelFactory);
            }
        }

      

        private void butCreateFacture_Click(object sender, RoutedEventArgs e)
        {
            txbResultatFacturation.Text = string.Empty;
          
            ChannelFactory<IFacturationExterneChannel> channelFactory = null;
            IFacturationExterneChannel channelServiceFacturation = null;
            try
            {
                TransportClientEndpointBehavior sharedSecretServiceBusCredential = new TransportClientEndpointBehavior();
                sharedSecretServiceBusCredential.CredentialType = TransportClientCredentialType.SharedSecret;
                sharedSecretServiceBusCredential.Credentials.SharedSecret.IssuerName = MagasinApplication.Properties.Settings.Default.IssuerName;
                sharedSecretServiceBusCredential.Credentials.SharedSecret.IssuerSecret = MagasinApplication.Properties.Settings.Default.IssuerSecret;

                channelFactory = new ChannelFactory<IFacturationExterneChannel>(new NetTcpRelayBinding(), new EndpointAddress(uriServiceFacturation));
                channelFactory.Endpoint.Behaviors.Add(sharedSecretServiceBusCredential);

                channelServiceFacturation = channelFactory.CreateChannel();
                channelServiceFacturation.Open();

                string resultat = channelServiceFacturation.AddBillingLine(
                    txtAuthorization.Text, txtDescription.Text, 
                    decimal.Parse(txtPrix.Text), decimal.Parse(txtTauxTva.Text), decimal.Parse(txtTva.Text));
                
                txbResultatFacturation.Text = resultat;
                
            }
            catch (Exception ex)
            {
                Debug.WriteLine(string.Format("Error sending: {0}\r\n{1}", ex.Message, ex.StackTrace));
            }
            finally
            {
                if (channelServiceFacturation != null)
                    CloseCommunicationObject(channelServiceFacturation);
                if (channelFactory != null)
                    CloseCommunicationObject(channelFactory);
            }
        }



        void CloseCommunicationObject(ICommunicationObject communicationObject)
        {
            bool shouldAbort = true;
            if (communicationObject.State == CommunicationState.Opened)
            {
                try
                {
                    communicationObject.Close();
                    shouldAbort = false;
                }
                catch (TimeoutException)
                {
                }
                catch (CommunicationException)
                {
                }
            }
            if (shouldAbort)
            {
                communicationObject.Abort();
            }
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            CreateUri();
        }
    }
}
