﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.Net;
using System.Collections.Specialized;
using Microsoft.ServiceBus;
using System.ServiceModel.Channels;

namespace MessageBufferClient
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        private static TransportClientEndpointBehavior CreationBehavior()
        {
            TransportClientEndpointBehavior behavior = new TransportClientEndpointBehavior();
            behavior.CredentialType = TransportClientCredentialType.SharedSecret;
            behavior.Credentials.SharedSecret.IssuerName = "owner";
            behavior.Credentials.SharedSecret.IssuerSecret = "ICI_VOTRE_ISSUER_KEY";
            return behavior;
        }

        private void butAddMessage_Click(object sender, RoutedEventArgs e)
        {
            TransportClientEndpointBehavior behavior = CreationBehavior();
            Uri uriMessageBuffer = new Uri("https://programmez-article-appfabric.servicebus.windows.net/DemoBufferDeMessage");

            Microsoft.ServiceBus.MessageBufferClient mbClient = Microsoft.ServiceBus.MessageBufferClient.GetMessageBuffer(behavior, uriMessageBuffer);

            mbClient.Send(
                Message.CreateMessage(
                    MessageVersion.Soap12WSAddressing10, 
                    "urn:Message", 
                    textBox1.Text)
               );


            MessageBox.Show("Message envoyé");
        }

        private void butRetrieve_Click(object sender, RoutedEventArgs e)
        {
            TransportClientEndpointBehavior behavior = CreationBehavior();
            Uri uriMessageBuffer = new Uri("https://programmez-article-appfabric.servicebus.windows.net/DemoBufferDeMessage");

            Microsoft.ServiceBus.MessageBufferClient mbClient = Microsoft.ServiceBus.MessageBufferClient.GetMessageBuffer(behavior, uriMessageBuffer);

            Message msg = mbClient.Retrieve();
            lblMessageRetrieved.Content = msg.GetBody<string>(); // = "Ceci est mon Message"

        }



        private void butPeekAndLock_Click(object sender, RoutedEventArgs e)
        {
            TransportClientEndpointBehavior behavior = CreationBehavior();
            Uri uriMessageBuffer = new Uri("https://programmez-article-appfabric.servicebus.windows.net/DemoBufferDeMessage");

            Microsoft.ServiceBus.MessageBufferClient mbClient = Microsoft.ServiceBus.MessageBufferClient.GetMessageBuffer(behavior, uriMessageBuffer);

            Message msg = mbClient.PeekLock();
            lblMessagePeekAndLock.Content = msg.GetBody<string>();
            lblMessageLockId.Content = msg;
        }

        private void butRealeaseLock_Click(object sender, RoutedEventArgs e)
        {
            TransportClientEndpointBehavior behavior = CreationBehavior();
            Uri uriMessageBuffer = new Uri("https://programmez-article-appfabric.servicebus.windows.net/DemoBufferDeMessage");

            Microsoft.ServiceBus.MessageBufferClient mbClient = Microsoft.ServiceBus.MessageBufferClient.GetMessageBuffer(behavior, uriMessageBuffer);
            
            Message msg = lblMessageLockId.Content as Message;

            mbClient.ReleaseLock(msg);

            lblMessageLockId.Content = null;
        }

        private void butDeleteLock_Click(object sender, RoutedEventArgs e)
        {

            TransportClientEndpointBehavior behavior = CreationBehavior();
            Uri uriMessageBuffer = new Uri("https://programmez-article-appfabric.servicebus.windows.net/DemoBufferDeMessage");

            Microsoft.ServiceBus.MessageBufferClient mbClient = Microsoft.ServiceBus.MessageBufferClient.GetMessageBuffer(behavior, uriMessageBuffer);

            Message msg = lblMessageLockId.Content as Message;
            mbClient.DeleteLockedMessage(msg);
            lblMessageLockId.Content = null;
        }

       
    }
}
