﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using Microsoft.ServiceBus;

namespace MessageBufferServer
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }




        private void butCreateBuffer_Click(object sender, RoutedEventArgs e)
        {
            TransportClientEndpointBehavior behavior = CreationBehavior();
            MessageBufferPolicy policy = CreateMessageBufferPolicy();

            Uri uriMessageBuffer = new Uri("https://programmez-article-appfabric.servicebus.windows.net/DemoBufferDeMessage");
            MessageBufferClient mbClient = MessageBufferClient.CreateMessageBuffer(behavior, uriMessageBuffer, policy);

            MessageBox.Show("Message Buffer created");
        }

        private void butDeleteBuffer_Click(object sender, RoutedEventArgs e)
        {
            TransportClientEndpointBehavior behavior = CreationBehavior();
            Uri uriMessageBuffer = new Uri("https://programmez-article-appfabric.servicebus.windows.net/DemoBufferDeMessage");

            MessageBufferClient mbClient = MessageBufferClient.GetMessageBuffer(behavior, uriMessageBuffer);
            mbClient.DeleteMessageBuffer();
        
            MessageBox.Show("Message buffer deleted");

        }

        private static MessageBufferPolicy CreateMessageBufferPolicy()
        {
            MessageBufferPolicy policy = new MessageBufferPolicy();
            policy.MaxMessageCount = 40;
            policy.ExpiresAfter = TimeSpan.FromMinutes(2);
            policy.Discoverability = DiscoverabilityPolicy.Public;
            policy.OverflowPolicy = OverflowPolicy.RejectIncomingMessage;
            policy.TransportProtection = TransportProtectionPolicy.None;
            policy.Authorization = AuthorizationPolicy.NotRequired;
            return policy;
        }

        private static TransportClientEndpointBehavior CreationBehavior()
        {
            TransportClientEndpointBehavior behavior = new TransportClientEndpointBehavior();
            behavior.CredentialType = TransportClientCredentialType.SharedSecret;
            behavior.Credentials.SharedSecret.IssuerName = "owner";
            behavior.Credentials.SharedSecret.IssuerSecret = "ICI_VOTRE_ISSUER_KEY";
            return behavior;
        }

      
    }
}
