﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Navigation;
using System.Windows.Shapes;
using System.ServiceModel.Web;

namespace RestaurantApplication
{
    /// <summary>
    /// Interaction logic for MainWindow.xaml
    /// </summary>
    public partial class MainWindow : Window
    {
        public MainWindow()
        {
            InitializeComponent();
        }

        WebServiceHost reservationHost = null;

        private void butExposeService_Click(object sender, RoutedEventArgs e)
        {
            if (reservationHost != null)
            {
                if (MessageBox.Show("Le service est déjà exposé.\r\nVoulez vous l'arréter ?", "Arret ?", MessageBoxButton.YesNo, MessageBoxImage.Question, MessageBoxResult.No) == MessageBoxResult.Yes)
                {
                    reservationHost.Close();
                }
                return;
            }
            // Ajouter Microsoft.ServiceBus.dll en référence
            Uri serviceUri = Microsoft.ServiceBus.ServiceBusEnvironment.CreateServiceUri(
                "https",
                RestaurantApplication.Properties.Settings.Default.ServiceNamespace,
                RestaurantApplication.Properties.Settings.Default.ServicePath);

            reservationHost = new WebServiceHost(typeof(Services.ReservationService), serviceUri);
            reservationHost.Open();

            MessageBox.Show("Les réservations sont ouvertes", "Info", MessageBoxButton.OK, MessageBoxImage.Information);
        }

        private void Window_Loaded(object sender, RoutedEventArgs e)
        {
            this.DataContext = ViewModel.RestaurantViewModelFactory.CurrentViewModel;
        }
    }
}
