﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using RestaurantApplicationContracts;
using System.ServiceModel;

namespace RestaurantApplication.Services
{
     
    [ServiceBehavior(Name = "ReservationService", Namespace = "http://restaurantapplication.sablefin.net/ServiceModel/Reservation/")]
    public class ReservationService : IRestaurantReservationContract
    {

        public string ReserverTable(string nomResa, long nbPersonnes, DateTime dateEtHeure, string remarque)
        {
            try
            {

                ViewModel.RestaurantViewModelFactory.CurrentViewModel.AjouterNouvelleReservation(nomResa, nbPersonnes, dateEtHeure, remarque);
                
            }
            catch
            {
                return "RESERVATION IMPOSSIBLE";
            }
            return "Réservation " + nomResa + " confirmé pour " + dateEtHeure.ToLongDateString() + " à " + dateEtHeure.ToLongTimeString();
        }
    }
}
