﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using System.ServiceModel.Web;

namespace RestaurantApplicationContracts
{
    /// <summary>
    /// Définition de l'interface du service, avec support du Binding REST
    /// </summary>
    [ServiceContract(Name = "IRestaurantReservationContract", 
        Namespace = "http://restaurantapplication.sablefin.net/ServiceModel/Reservation/")]
    public interface IRestaurantReservationContract
    {
        [OperationContract] // déclaration d'un méthode de service
        [WebGet(UriTemplate = "/Reserver?nomResa={nomResa}&nbPersonnes={nbPersonnes}&dateEtHeure={dateEtHeure}&remarque={remarque}")]
        string ReserverTable(string nomResa,long nbPersonnes,DateTime dateEtHeure,string remarque);
    }


    /// <summary>
    /// Interface de service pour WCF & AppFabric
    /// </summary>
    public interface IRestaurantReservationChannel : IRestaurantReservationContract, IClientChannel { }
}
