<?php

/*
 * Obtenir le titre d'un PDF à télécharger
 */
function lesite_abopdf_item_name($thenum) {
	  	$sql = "SELECT nid FROM {content_type_pdf_pour_abo} WHERE field_issue_pdf4abo_value = %d";
  		$node = node_load(db_result(db_query($sql, $thenum)));
  		return $node->title;
}

/*
 * Obtenir le nb de téléchargement pour un mag
 * Si l'entrée n'existe pas dans la table, on la crée à la volée.
 * Voir le commentaire de la fonction lesite_abopdf_record_purchased
 */
function _lesite_abopdf_get_state_download($account, $thenum, $model) {
	$sql = "SELECT nb_dl, seuil FROM {lesite_abopdf_downloads} WHERE uid = %d AND issue = %d ORDER BY abopdf_dl_id DESC";
	$result = db_query_range($sql, $account->uid, $thenum, 0, 1);
	$dls =  db_fetch_object($result);
	if($dls == FALSE) {
		$sql = "SELECT download_limit FROM {lesite_abopdf} WHERE uid = %d and model = '%s' ORDER BY date_paiement";
		$dl_limit = db_result(db_query_range($sql, $account->uid, $model, 0, 1));
		$record =  new stdClass();
		$record->uid = $account->uid;
		$record->issue = $thenum;
		$record->nb_dl = 0;
		$record->seuil = $dl_limit;
		$record->date_dl = '0000-00-00 00:00:00';
		$record->created = date('Y-m-d H:i:s');
		drupal_write_record('lesite_abopdf_downloads', $record);
		return array(
			nb_dl => 0,
			dl_limit => $dl_limit,
		);
	}
	return array(
		nb_dl => $dls->nb_dl,
		dl_limit => $dls->seuil,
	);
}

/*
 * Construire le lien de téléchargement
 */
function lesite_abopdf_build_download_link($account, $thenum, $model) {
	$sql = "SELECT field_pdf4download_value, field_parution_prevue_pdf4abo_value FROM {content_type_pdf_pour_abo} WHERE field_issue_pdf4abo_value = %d";
	$result = db_query($sql, $thenum);
	$issue =  db_fetch_object($result);
	$fichier = $issue->field_pdf4download_value;
	$estimated = date('d F Y', strtotime($issue->field_parution_prevue_pdf4abo_value));
	
	if($fichier == 'not-yet') {	
		return "A paraître - To be released<BR /> Date estimée -- Estimated time : " . $estimated;	
	}

	$lien = l("Télécharger - Download", "abopdf-download/" . $account->uid . "/" . $thenum);	
	$etat_dl = _lesite_abopdf_get_state_download($account, $thenum, $model);
	$lien .= " (" . $etat_dl['nb_dl'] . "/" . $etat_dl['dl_limit'] . ")";
	return $lien;
}


/*
 * le callback pour le menu page qui génère l'onglet Abonnement PDF
 */
function lesite_abopdf_available_pdf_downloads($account) {
	$content ="<p />";
	$model = 'abo-pdf-1an';
	$expiration = _lesite_abopdf_get_expiration($account, $model);
	
	$msg = "<p>Votre abonnement PDF se terminera le " . $expiration;
	$content .= $msg;
	
	$sql = "SELECT first_issue, nb_issues FROM {lesite_abopdf} WHERE uid = %d AND model='abo-pdf-1an' ORDER BY date_paiement";
	$result = db_query_range($sql, $account->uid, 0, 1);
	$abo = db_fetch_object($result);
	// Si un rôle est attribue par l'admin via uc_role sans que le client ait commande un abo
	// le premier num de l'abonnement n'existe pas
	if($abo == FALSE) {
		
		return $content;
	}
		
	for($i=$abo->first_issue; $i<$abo->first_issue+$abo->nb_issues; $i++) {
		$content .= lesite_abopdf_item_name($i);
		$content .= '<br />' . lesite_abopdf_build_download_link($account, $i, $model);
		$content .= '<br /><p />';
	}
	
	return $content;
	
}

function lesite_abopdf_download($user_id, $thenum) {
	// Est-ce que le numéro demandé fait partie des 4 numéro de l'abonnement en cours ?
	$sql = "SELECT first_issue, nb_issues FROM {lesite_abopdf} WHERE uid = %d AND model='abo-pdf-1an' ORDER BY date_paiement";
	$result = db_query_range($sql, (int)$user_id, 0, 1);
	$abo = db_fetch_object($result);
	$first = $abo->first_issue;
	$last = $first + $abo->nb_issues;
	if(!((int)$thenum >= $first && (int)$thenum < $last)) {
		watchdog('lesite_abopdf', 'L\'utilisateur @user a tenté de télécharger illégalement le numéro @numero.', array('@user' => $user_id, '@numero' => $thenum), WATCHDOG_ERROR);
		$msg = "Vous avez tenté de télécharger un numéro de lesite Magazine auquel votre abonnement ne vous donne pas droit. Cette tentative a été signalée au webmaster. <br />You tried to download a number of lesite Magazine that your subscription does not entitle you. This attempt has been reported to the webmaster.";
		drupal_set_message($msg, 'error');
		drupal_not_found();
		return;
	}
	// Obtenir le nom de fichier et vérifier que le numéro est paru
	$sql = "SELECT field_pdf4download_value FROM {content_type_pdf_pour_abo} WHERE field_issue_pdf4abo_value =%d";
	$thefile = db_result(db_query($sql, (int)$thenum));
	if($thefile == 'not-yet') {
		watchdog('lesite_abopdf', 'L\'utilisateur @user tenté de télécharger un numéro qui n\'est pas encore paru', array('@user' => $user_id), WATCHDOG_WARNING);
		$msg = "Vous avez tenté de télécharger un numéro de lesite Magazine qui n'est pas encore paru.<br />You tried to download an issue of lesite Magazine which is not yet published.";
		drupal_set_message($msg, 'error');
		drupal_not_found();
		return;
	}
	
	// La limite de téléchargement est-elle atteinte ?
	$sql = "SELECT abopdf_dl_id, nb_dl, seuil FROM {lesite_abopdf_downloads} WHERE uid = %d AND issue = %d ORDER BY abopdf_dl_id DESC";
	$result = db_query_range($sql, (int)$user_id, (int)$thenum, 0, 1);
	$dls =  db_fetch_object($result);
	if($dls == FALSE) {
		// problème, l'enregistrement devrait exister
		// Si on arrive là, c'est sans doute qu'une tentative de téléchargement illégale
		// est parvenue jusque là.
		watchdog('lesite_abopdf', 'Pas d\'enregistrement dans lesite_abopdf_downloads pour l\'utilisateur @user et le le numéro @numero.', array('@user' => $user_id, '@numero' => $thenum), WATCHDOG_ERROR);
		return;
	}
	if($dls->nb_dl >= $dls->seuil) {
		watchdog('lesite_abopdf', 'L\'utilisateur @user a déjà atteint la limite de téléchargements pour le numéro @numero.', array('@user' => $user_id, '@numero' => $thenum), WATCHDOG_INFO);
		$msg = "Vous avez atteint la limite de téléchargements pour ce numéro de lesite Magazine.<br />You've reached the limit of downloads for this issue of lesite Magazine.";
		drupal_set_message($msg, 'error');
		drupal_not_found();
		return;
	}
	
	// C'est ok -> transférer le PDF
	lesite_abopdf_file_transfer($thefile);
	//consigner dans le log que c'est fait
	watchdog('lesite_abopdf', 'L\'utilisateur @user a téléchargé le numéro @numero.', array('@user' => $user_id, '@numero' => $thenum), WATCHDOG_INFO);
	// Consigner le téléchargement dans la table lesite_abopdf_downloads
	// sauf si c'est un essai de l'admin sur un autre compte que le sien
	global $user;
	if($user->uid == 1 && $user_id != 1) {
		drupal_goto('user/'. (int)$user_id .'/abonnement-pdf');
		return;
	}
	$dls->nb_dl += 1;
	$dls->date_dl = date('Y-m-d H:i:s');
	drupal_write_record('lesite_abopdf_downloads', $dls, 'abopdf_dl_id');
	if (!headers_sent()) {
		drupal_goto('user/'. (int)$user_id .'/abonnement-pdf');
	}
}

/*
 * Servir son fichier à l'utilisateur 
 * ce code est tiré pour l'essentiel du module uc_file
 * fichier uc_file.pages.inc fonction _uc_file_download_transfer
 */
function lesite_abopdf_file_transfer($thefile) {
	$fullfilename = variable_get('uc_file_base_dir', "") . "/" . $thefile;
	
	// Gather relevant info about the file.
	$size = filesize($fullfilename);
	$mimetype = file_get_mimetype($thefile);
	
	$filename = $thefile;
	// Workaround for IE filename bug with multiple periods / multiple dots
	// in filename that adds square brackets to filename -
	// eg. setup.abc.exe becomes setup[1].abc.exe
	if (strstr($_SERVER['HTTP_USER_AGENT'], 'MSIE')) {
		$filename = preg_replace('/\./', '%2e', $filename, substr_count($filename, '.') - 1);
	}
	
	// Check if HTTP_RANGE is sent by browser (or download manager)
	$range = NULL;
	if (isset($_SERVER['HTTP_RANGE'])) {
		list($size_unit, $range_orig) = explode('=', $_SERVER['HTTP_RANGE'], 2);
		
		if ($size_unit == 'bytes') {
			// Multiple ranges could be specified at the same time,
			// but for simplicity only serve the first range
			// See http://tools.ietf.org/id/draft-ietf-http-range-retrieval-00.txt
			list($range, $extra_ranges) = explode(',', $range_orig, 2);
		}
	}
	
	// Figure out download piece from range (if set)
	if (isset($range)) {
		list($seek_start, $seek_end) = explode('-', $range, 2);
	}
	
	// Set start and end based on range (if set),
	// else set defaults and check for invalid ranges.
	$seek_end = intval((empty($seek_end)) ? ($size - 1) : min(abs(intval($seek_end)), ($size - 1)));
	$seek_start = intval((empty($seek_start) || $seek_end < abs(intval($seek_start))) ? 0 : max(abs(intval($seek_start)), 0));
	
	// Only send partial content header if downloading a piece of the file (IE
	// workaround).
	if ($seek_start > 0 || $seek_end < ($size - 1)) {
		drupal_set_header('HTTP/1.1 206 Partial Content');
	}

	// Standard headers, including content-range and length
	drupal_set_header('Pragma: public');
	drupal_set_header('Cache-Control: cache, must-revalidate');
	drupal_set_header('Accept-Ranges: bytes');
	drupal_set_header('Content-Range: bytes '. $seek_start .'-'. $seek_end .'/'. $size);
	drupal_set_header('Content-Type: '. $mimetype);
	drupal_set_header('Content-Disposition: attachment; filename="'. $filename .'"');
	drupal_set_header('Content-Length: '. ($seek_end - $seek_start + 1));

	// Last-Modified is required for content served dynamically
	drupal_set_header('Last-Modified: '. gmdate("D, d M Y H:i:s", filemtime($fullfilename)) ." GMT");

	// Etag header is required for Firefox3 and other managers
	drupal_set_header('ETag: '. md5($fullfilename));
	
	// Open the file and seek to starting byte
	$fp = fopen($fullfilename, 'rb');
	fseek($fp, $seek_start);

	// Start buffered download
	while (!feof($fp)) {

		// Reset time limit for large files
		set_time_limit(0);
		
		// Push the data to the client.
		print(fread($fp, 8192));
		flush();
		
		// Not sure why ob_flush() is required here, but leaving it out breaks
		// some systems (clicking on link doesn't download anything without it).
		ob_flush();
	}

	// Finished serving the file, close the stream and log the download
	// to the user table.
	fclose($fp);
}
