// DemoListVM.cpp 

#include <iostream>

using namespace std;

#include <COMUtils.h>
#include "VirtualBox.h"

int main(int argc, char* argv[])
{
	try
	{
		COMInitializer ci;
		HRESULT hr;
		SmartCOMPtr<IVirtualBox> virtualBox;
		SAFEARRAY* machinesSafeArray;
		IMachine** machines;

		// Crer une instance COM VirtualBox
		hr = ::CoCreateInstance(CLSID_VirtualBox,
                          NULL,
                          CLSCTX_LOCAL_SERVER,
                          IID_IVirtualBox,
                          (void **)&virtualBox);
		COMHelper::TestOk(hr);
		// Obtenir le tableau de machines virtuelles
		hr = virtualBox->get_Machines(&machinesSafeArray);
		COMHelper::TestOk(hr);
		// Accder aux donnes du tableau
		hr = ::SafeArrayAccessData(machinesSafeArray, (void **)&machines);
		COMHelper::TestOk(hr);
		for (ULONG i = 0; i < machinesSafeArray->rgsabound[0].cElements; ++i)
        {
			BSTR str;
            hr = machines[i]->get_Name(&str);
            if (hr >= 0)
			{
				wcout << "Machine virtuelle: " << str << endl;
				::SysFreeString(str);
            }
        }
		::SafeArrayUnaccessData(machinesSafeArray);
		::SafeArrayDestroy(machinesSafeArray);
		cin.get();
	}
	catch(COMException ce)
	{
		std::cout << ce.raison() << std::endl;
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}


