#include <cuda.h>

#include <iostream>
using namespace std;

int main(int argc, char** argv)
{
	// Initialiser CUDA
	CUresult result = cuInit(0);
	switch(result)
	{
	case CUDA_SUCCESS:
		cout << "Librairie CUDA initialisee correctement" << endl;
		break;
	case CUDA_ERROR_INVALID_VALUE:
	case CUDA_ERROR_NO_DEVICE:
	default:
		cout << "Une erreur s'est produite  l'initialisation de CUDA" << endl;
		return EXIT_FAILURE;
	}

	// Combien de cartes graphiques Nvidia/CUDA sur la machine ?
	int nb_gpu;
	cuDeviceGetCount(&nb_gpu);
	cout << "Nb de GPU CUDA sur cette machine: " << nb_gpu << endl;

	// Obtenir un Handle sur la carte 0
	CUdevice device;
	cuDeviceGet(&device, 0); 

	// Obtenire le nom de la carte 0
	char buffer[256];
	cuDeviceGetName(buffer, sizeof(buffer), device);
	cout << "Nom de la carte 0:" << endl;
	cout << buffer << endl;

	// Obtenir les proprits de la carte 0
	CUdevprop prop;
	cuDeviceGetProperties(&prop, device); 
	cout << "Threads par blocks : " << prop.maxThreadsPerBlock << endl;

	cout << "Dimensions maximales d'un bloc" << endl;
	cout << "x: " << prop.maxThreadsDim[0] << endl;
	cout << "y: " << prop.maxThreadsDim[1] << endl;
	cout << "z: " << prop.maxThreadsDim[2] << endl;

	cout << "Dimensions maximales d'une grille" << endl;
	cout << "x: " << prop.maxGridSize[0] << endl;
	cout << "y: " << prop.maxGridSize[1] << endl;
	cout << "z: " << prop.maxGridSize[2] << endl;

	cout << "Taille de la memoire partagee par bloc: "
		<< prop.sharedMemPerBlock << endl;
	cout << "Taille de la memoire constante totale: "
		<< prop.totalConstantMemory << endl;
	cout << "Taille des voilures: " << prop.SIMDWidth << endl;
	cout << "Pitch memoire: " << prop.memPitch << endl;
	cout << "Nb de registres par bloc: " << prop.regsPerBlock << endl;
	cout << "Frequence d'horloge: " << prop.clockRate << endl;
	cout << "Pas d'alignement de textures: " << prop.textureAlign << endl;

	// Obtenir la mmoire totale sur la carte 0
	unsigned int all_mem;
	cuDeviceTotalMem(&all_mem, device);
	cout << "Memoire totale: " << all_mem
		<< " ---> " << all_mem/(1024*1024) << "Mo" << endl;

	// Enfin obtenir deux proprits qui ne
	// figurent pas dans CUdevprop
	int value;
	cuDeviceGetAttribute(&value, CU_DEVICE_ATTRIBUTE_GPU_OVERLAP, device);
	cout << "Possibilite de transfert memoire" << endl;
	cout << "lors de l'execution d'un kernel: " << value << endl;

	cuDeviceGetAttribute(&value,
		CU_DEVICE_ATTRIBUTE_MULTIPROCESSOR_COUNT, device);
	cout << "Nb de multi-processeurs sur la carte: " << value << endl;

	return 0;
}

