#include <stdio.h>

#include <cuda.h>
#include <vector_types.h>

void init()
{
	// Initialiser CUDA
	CUresult result = cuInit(0);
	switch(result)
	{
	case CUDA_SUCCESS:
		puts("Librairie CUDA initialisee correctement");
		break;
	case CUDA_ERROR_INVALID_VALUE:
	case CUDA_ERROR_NO_DEVICE:
	default:
		puts("Une erreur s'est produite  l'initialisation de CUDA");
		exit(1);
	}
	cudaSetDevice(0);
}



__global__ void incVec(int3 *v)
{
	v->x = threadIdx.x;
	v->y = threadIdx.x;
	v->z = threadIdx.x;
}

void run(int3 *v)
{
	int3 *gpu_v;
	int size;
	
	size = sizeof(int3); // et non sizeof(gpu_v) Attention :)
	cudaMalloc((void**)&gpu_v, size);
	cudaMemcpy(gpu_v, v, size, cudaMemcpyHostToDevice);
	
	incVec<<<1, 1>>>(gpu_v);
	
	cudaMemcpy(v, gpu_v, size, cudaMemcpyDeviceToHost);
	cudaFree(gpu_v);
}


void print_vector(int3 *v)
{
	printf("x: %d, y: %d, z: %d\n", v->x, v->y, v->z);	
}

int main(int argc, char** argv)
{
	int3 v;
	
	init();
	v = make_int3(-1, -1, -1);
	print_vector(&v);
	run(&v);
	print_vector(&v);
	return 0;
}

