#include <iostream>

using namespace std;

#include <cuda.h>
#include <vector_types.h>

// dclaration anticipe
extern "C" void run(int3 *v);
// Exporter print_vector pour usage dans kernel_cpp;cu
extern "C" void print_vector(int3 *v);

void init()
{
	// Initialiser CUDA
	CUresult result = cuInit(0);
	switch(result)
	{
	case CUDA_SUCCESS:
		puts("Librairie CUDA initialisee correctement");
		break;
	case CUDA_ERROR_INVALID_VALUE:
	case CUDA_ERROR_NO_DEVICE:
	default:
		puts("Une erreur s'est produite  l'initialisation de CUDA");
		exit(1);
	}
}

void print_vector(int3 *v)
{
	cout << "x: " << v->x << ", y: " << v->y << ", z: " << v->z << endl;	
}

int main(int argc, char* argv[])
{
	cout << "IncVector version C++" << endl;
	
	int3 v;
	
	init();
	// Dplace dans kernel_cpp.cu
	//v = make_int3(-1, -1, -1);
	//print_vector(&v);
	run(&v);
	print_vector(&v);
	return 0;
}

