#include <cuda.h>
#include <vector_types.h>

// Dclaration anticipe
__global__ void incVec(int3 *v);
extern "C" void print_vector(int3 *v);

extern "C" void run(int3 *v)
{
	int3 *gpu_v;
	int size;
	
	*v = make_int3(-1, -1, -1);
	
	print_vector(v);
	
	size = sizeof(int3); // et non sizeof(gpu_v) Attention :)
	cudaMalloc((void**)&gpu_v, size);
	cudaMemcpy(gpu_v, v, size, cudaMemcpyHostToDevice);
	
	incVec<<<1, 1>>>(gpu_v);
	
	cudaMemcpy(v, gpu_v, size, cudaMemcpyDeviceToHost);
	cudaFree(gpu_v);
}

__global__ void incVec(int3 *v)
{
	v->x = threadIdx.x;
	v->y = threadIdx.x;
	v->z = threadIdx.x;
}


