"""Setup the programmez application"""
import logging

import pylons.test

from programmez.config.environment import load_environment
from programmez.model.meta import Session, Base

log = logging.getLogger(__name__)

def setup_app(command, conf, vars):
    """Place any commands to setup programmez here"""
    # Don't reload the app if it was loaded under the testing environment
    if not pylons.test.pylonsapp:
        load_environment(conf.global_conf, conf.local_conf)
        from programmez.model.meta import Base, Session
        from programmez.model.personne import Personne
        log.info("Creation des  tables")
        Base.metadata.drop_all(checkfirst=True, bind=Session.bind)
        Base.metadata.create_all(bind=Session.bind)
        log.info("Fin de l'initialisation")


    # Create the tables if they don't already exist
    Base.metadata.create_all(bind=Session.bind)
