package org.eclipse.draw2d {
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import String;
import java.lang.Arguments;
dynamic public class AbstractLabeledBorder extends AbstractBorder implements LabeledBorder {
  private var textExtents: Dimension;
  private var label: String;
  private var insets: Insets;
  private var textColor: Color = org.eclipse.draw2d.ColorConstants$$fields.black;
  private var font: Font;
  public function AbstractLabeledBorder__(): Object {
    var className: String = Object(this).getClass__().getName__();
    this.setLabel__Ljava_lang_String_2(Object(className).substring__II(Object(className).lastIndexOf__I(46) + 1, Object(className).length__()));
    return this;
  }
  public function AbstractLabeledBorder__Ljava_lang_String_2(s: String): Object {
    this.setLabel__Ljava_lang_String_2(s);
    return this;
  }
  public function calculateInsets__Lorg_eclipse_draw2d_IFigure_2(figure: IFigure): Insets { // abstract
    return null;
  }
  public function getFont__Lorg_eclipse_draw2d_IFigure_2(f: IFigure): Font {
    if (font === null)
      return f.getFont__();
    return font;
  }
  public override function getInsets__Lorg_eclipse_draw2d_IFigure_2(fig: IFigure): Insets {
    if (insets === null)
      insets = this.calculateInsets__Lorg_eclipse_draw2d_IFigure_2(fig);
    return insets;
  }
  public function getLabel__(): String {
    return label;
  }
  public override function getPreferredSize__Lorg_eclipse_draw2d_IFigure_2(fig: IFigure): Dimension {
    return new Dimension(new Arguments(org.eclipse.draw2d.geometry.Dimension.Dimension__Lorg_eclipse_draw2d_geometry_Dimension_2, [this.getTextExtents__Lorg_eclipse_draw2d_IFigure_2(fig)]));
  }
  public function getTextColor__(): Color {
    return textColor;
  }
  public function getTextExtents__Lorg_eclipse_draw2d_IFigure_2(f: IFigure): Dimension {
    if (textExtents === null)
      textExtents = FigureUtilities.getTextExtents__Ljava_lang_String_2Lorg_eclipse_swt_graphics_Font_2(label, this.getFont__Lorg_eclipse_draw2d_IFigure_2(f));
    return textExtents;
  }
  public function invalidate__(): void {
    insets = null;
    textExtents = null;
  }
  public function setFont__Lorg_eclipse_swt_graphics_Font_2(font_1: Font): void {
    this.font = font_1;
    this.invalidate__();
  }
  public function setLabel__Ljava_lang_String_2(s: String): void {
    label = ((s === null) ? "" : s);
    this.invalidate__();
  }
  public function setTextColor__Lorg_eclipse_swt_graphics_Color_2(color: Color): void {
    textColor = color;
  }
  public override function paint__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Graphics_2Lorg_eclipse_draw2d_geometry_Insets_2(arg0: IFigure, arg1: Graphics, arg2: Insets): void { } // abstract
  public function AbstractLabeledBorder(... vargs) {
    var args: Array;
    var id: int;
    if (vargs.length == 1 && vargs[0] is Arguments) {
      args = Arguments(vargs[0]).args;
      id = Arguments(vargs[0]).id;
    } else {
      if (vargs.length == 0) {
        id = 0;
      } else if (vargs.length == 1 && vargs[0] is String) {
        args = vargs;
        id = 1;
      }
    }
    switch (id) {
      case 0:
        break;
      case 1:
        var args1: Array = [args[0]];
        break;
    }
    super();
    switch (id) {
      case 0:
        AbstractLabeledBorder__();
        break;
      case 1:
        AbstractLabeledBorder__Ljava_lang_String_2(args1[0]);
        break;
    }
  }
  public static const AbstractLabeledBorder__ : int = 0;
  public static const AbstractLabeledBorder__Ljava_lang_String_2 : int = 1;
}
}
