package org.eclipse.draw2d {
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import java.lang.Arguments;
dynamic public class AbstractLocator implements Locator {
  private var relativePosition: int = 2;
  private var gap: int;
  public function AbstractLocator() {
    return;
  }
  public function getGap__(): int {
    return gap;
  }
  public function getReferencePoint__(): Point { // abstract
    return null;
  }
  public function getNewBounds__Lorg_eclipse_draw2d_geometry_Dimension_2Lorg_eclipse_draw2d_geometry_Point_2(size: Dimension, center: Point): Rectangle {
    var bounds: Rectangle = new Rectangle(new Arguments(org.eclipse.draw2d.geometry.Rectangle.Rectangle__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Dimension_2, [center, size]));
    bounds.x -= int(bounds.width / 2);
    bounds.y -= int(bounds.height / 2);
    var xFactor: int = 0;
    var yFactor: int = 0;
    var position: int = this.getRelativePosition__();
    if ((position & 1) != 0)
      yFactor = -1;
    else if ((position & 4) != 0)
      yFactor = 1;
    if ((position & 8) != 0)
      xFactor = -1;
    else if ((position & 16) != 0)
      xFactor = 1;
    bounds.x += xFactor * (int(bounds.width / 2) + this.getGap__());
    bounds.y += yFactor * (int(bounds.height / 2) + this.getGap__());
    return bounds;
  }
  public function getRelativePosition__(): int {
    return relativePosition;
  }
  public function relocate__Lorg_eclipse_draw2d_IFigure_2(target: IFigure): void {
    var prefSize: Dimension = target.getPreferredSize__();
    var center: Point = this.getReferencePoint__();
    target.translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(center);
    target.setBounds__Lorg_eclipse_draw2d_geometry_Rectangle_2(this.getNewBounds__Lorg_eclipse_draw2d_geometry_Dimension_2Lorg_eclipse_draw2d_geometry_Point_2(prefSize, center));
  }
  public function setGap__I(i: int): void {
    gap = i;
  }
  public function setRelativePosition__I(pos: int): void {
    relativePosition = pos;
  }
}
}
