package org.eclipse.draw2d {
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import java.util.Iterator;
import java.lang.Arguments;
dynamic public class AbstractPointListShape extends Shape {
  internal var points: PointList = new PointList(new Arguments(org.eclipse.draw2d.geometry.PointList.PointList__, []));
  public override function containsPoint__II(x: int, y: int): Boolean {
    if (!super.containsPoint__II(x, y)) {
      return false;
    }
    return this.shapeContainsPoint__II(x, y) || this.childrenContainsPoint__II(x, y);
  }
  public function childrenContainsPoint__II(x: int, y: int): Boolean {
    for (var it: Iterator = Iterator(this.getChildren__().iterator__()); it.hasNext__();) {
      var nextChild: IFigure = IFigure(it.next__());
      if (nextChild.containsPoint__II(x, y)) {
        return true;
      }
    }
    return false;
  }
  public function shapeContainsPoint__II(x: int, y: int): Boolean { // abstract
    return false;
  }
  public function addPoint__Lorg_eclipse_draw2d_geometry_Point_2(pt: Point): void {
    this.erase__();
    points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(pt);
    this.repaint__();
  }
  public function getStart__(): Point {
    return points.getFirstPoint__();
  }
  public function getEnd__(): Point {
    return points.getLastPoint__();
  }
  public function getPoints__(): PointList {
    return points;
  }
  public function insertPoint__Lorg_eclipse_draw2d_geometry_Point_2I(pt: Point, index: int): void {
    this.erase__();
    points.insertPoint__Lorg_eclipse_draw2d_geometry_Point_2I(pt, index);
    this.repaint__();
  }
  public function removeAllPoints__(): void {
    this.erase__();
    points.removeAllPoints__();
  }
  public function removePoint__I(index: int): void {
    this.erase__();
    points.removePoint__I(index);
    this.repaint__();
  }
  public function setStart__Lorg_eclipse_draw2d_geometry_Point_2(start: Point): void {
    if (points.size__() == 0) {
      this.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(start);
    } else {
      this.setPoint__Lorg_eclipse_draw2d_geometry_Point_2I(start, 0);
    }
    return;
  }
  public function setEnd__Lorg_eclipse_draw2d_geometry_Point_2(end: Point): void {
    if (points.size__() < 2) {
      this.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(end);
    } else {
      this.setPoint__Lorg_eclipse_draw2d_geometry_Point_2I(end, points.size__() - 1);
    }
    return;
  }
  public function setEndpoints__Lorg_eclipse_draw2d_geometry_Point_2Lorg_eclipse_draw2d_geometry_Point_2(start: Point, end: Point): void {
    this.setStart__Lorg_eclipse_draw2d_geometry_Point_2(start);
    this.setEnd__Lorg_eclipse_draw2d_geometry_Point_2(end);
    return;
  }
  public function setPoint__Lorg_eclipse_draw2d_geometry_Point_2I(pt: Point, index: int): void {
    this.erase__();
    points.setPoint__Lorg_eclipse_draw2d_geometry_Point_2I(pt, index);
    this.repaint__();
    return;
  }
  public function setPoints__Lorg_eclipse_draw2d_geometry_PointList_2(points_1: PointList): void {
    this.erase__();
    this.points = points_1;
    this.repaint__();
    return;
  }
}
}
