package org.eclipse.draw2d {
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.System;
import java.lang.JavaArray;
dynamic public class AncestorHelper implements PropertyChangeListener, FigureListener {
  public var base: IFigure;
  public var listeners: JavaArray;
  public function AncestorHelper(baseFigure: IFigure) {
    this.base = baseFigure;
    this.addAncestors__Lorg_eclipse_draw2d_IFigure_2(baseFigure);
    return;
  }
  public function addAncestorListener__Lorg_eclipse_draw2d_AncestorListener_2(listener: AncestorListener): void {
    if (listeners === null) {
      listeners = new JavaArray("[Lorg/eclipse/draw2d/AncestorListener;").lengths(1);
      listeners[0] = listener;
    } else {
      var oldSize: int = listeners.length;
      var newListeners: JavaArray = new JavaArray("[Lorg/eclipse/draw2d/AncestorListener;").lengths(oldSize + 1);
      System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(listeners, 0, newListeners, 0, oldSize);
      newListeners[oldSize] = listener;
      listeners = newListeners;
    }
    return;
  }
  public function addAncestors__Lorg_eclipse_draw2d_IFigure_2(rootFigure: IFigure): void {
    for (var ancestor: IFigure = rootFigure; ancestor !== null; ancestor = ancestor.getParent__()) {
      ancestor.addFigureListener__Lorg_eclipse_draw2d_FigureListener_2(this);
      ancestor.addPropertyChangeListener__Ljava_lang_String_2Ljava_beans_PropertyChangeListener_2("parent", this);
    }
    return;
  }
  public function dispose__(): void {
    this.removeAncestors__Lorg_eclipse_draw2d_IFigure_2(base);
    listeners = null;
    return;
  }
  public function figureMoved__Lorg_eclipse_draw2d_IFigure_2(ancestor: IFigure): void {
    this.fireAncestorMoved__Lorg_eclipse_draw2d_IFigure_2(ancestor);
    return;
  }
  public function fireAncestorMoved__Lorg_eclipse_draw2d_IFigure_2(ancestor: IFigure): void {
    if (listeners === null)
      return;
    for (var i: int = 0; i < listeners.length; i++)
      listeners[i].ancestorMoved__Lorg_eclipse_draw2d_IFigure_2(ancestor);
  }
  public function fireAncestorAdded__Lorg_eclipse_draw2d_IFigure_2(ancestor: IFigure): void {
    if (listeners === null)
      return;
    for (var i: int = 0; i < listeners.length; i++)
      listeners[i].ancestorAdded__Lorg_eclipse_draw2d_IFigure_2(ancestor);
  }
  public function fireAncestorRemoved__Lorg_eclipse_draw2d_IFigure_2(ancestor: IFigure): void {
    if (listeners === null)
      return;
    for (var i: int = 0; i < listeners.length; i++)
      listeners[i].ancestorRemoved__Lorg_eclipse_draw2d_IFigure_2(ancestor);
  }
  public function isEmpty__(): Boolean {
    return listeners === null;
  }
  public function propertyChange__Ljava_beans_PropertyChangeEvent_2(event: PropertyChangeEvent): void {
    if (Object(event.getPropertyName__()).equals__Ljava_lang_Object_2("parent")) {
      var oldParent: IFigure = IFigure(event.getOldValue__());
      var newParent: IFigure = IFigure(event.getNewValue__());
      if (oldParent !== null) {
        this.removeAncestors__Lorg_eclipse_draw2d_IFigure_2(oldParent);
        this.fireAncestorRemoved__Lorg_eclipse_draw2d_IFigure_2(oldParent);
      }
      if (newParent !== null) {
        this.addAncestors__Lorg_eclipse_draw2d_IFigure_2(newParent);
        this.fireAncestorAdded__Lorg_eclipse_draw2d_IFigure_2(newParent);
      }
    }
    return;
  }
  public function removeAncestorListener__Lorg_eclipse_draw2d_AncestorListener_2(listener: AncestorListener): void {
    if (listeners === null)
      return;
    for (var index: int = 0; index < listeners.length; index++)
      if (listeners[index] === listener) {
        var newSize: int = listeners.length - 1;
        var newListeners: JavaArray = null;
        if (newSize != 0) {
          newListeners = new JavaArray("[Lorg/eclipse/draw2d/AncestorListener;").lengths(newSize);
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(listeners, 0, newListeners, 0, index);
          System.arraycopy__Ljava_lang_Object_2ILjava_lang_Object_2II(listeners, index + 1, newListeners, index, newSize - index);
        }
        listeners = newListeners;
        return;
      }
    return;
  }
  public function removeAncestors__Lorg_eclipse_draw2d_IFigure_2(rootFigure: IFigure): void {
    for (var ancestor: IFigure = rootFigure; ancestor !== null; ancestor = ancestor.getParent__()) {
      ancestor.removeFigureListener__Lorg_eclipse_draw2d_FigureListener_2(this);
      ancestor.removePropertyChangeListener__Ljava_lang_String_2Ljava_beans_PropertyChangeListener_2("parent", this);
    }
    return;
  }
}
}
