package org.eclipse.draw2d {
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Set;
import java.util.Map;
import java.util.Iterator;
import java.lang.System;
import java.util.HashMap;
import java.util.HashSet;
import java.lang.Arguments;
dynamic public class Animation {
  public static const DEFAULT_DELAY: int = 250;
  public static var figureAnimators: Set;
  public static var finalStates: Map;
  public static var initialStates: Map;
  public static const PLAYBACK: int = 3;
  public static var progress: Number = 0;
  public static const RECORD_FINAL: int = 2;
  public static const RECORD_INITIAL: int = 1;
  public static var startTime: Number = 0;
  public static var state: int;
  public static var toCapture: Set;
  public static var updateManager: UpdateManager;
  private static function capture__(): void {
    var keys: Iterator = Iterator(figureAnimators.iterator__());
    while (keys.hasNext__()) {
      var pair: Animation$AnimPair = Animation$AnimPair(keys.next__());
      if (toCapture.contains__Ljava_lang_Object_2(pair))
        pair.animator.capture__Lorg_eclipse_draw2d_IFigure_2(pair.figure);
      else
        keys.remove__();
    }
    return;
  }
  public static function cleanup__(): void {
    if (figureAnimators !== null) {
      var keys: Iterator = Iterator(figureAnimators.iterator__());
      while (keys.hasNext__()) {
        var pair: Animation$AnimPair = Animation$AnimPair(keys.next__());
        pair.animator.tearDown__Lorg_eclipse_draw2d_IFigure_2(pair.figure);
      }
    }
    state = 0;
    step__();
    initialStates = null;
    finalStates = null;
    figureAnimators = null;
    updateManager = null;
    toCapture = null;
    state = 0;
    return;
  }
  private static function doRun__I(duration: int): void {
    state = 2;
    findUpdateManager__();
    updateManager.performValidation__();
    capture__();
    state = 3;
    progress = 0.10000000149011612;
    startTime = System.currentTimeMillis__();
    notifyPlaybackStarting__();
    while (progress != 0) {
      step__();
      updateManager.performUpdate__();
      if (progress == 1.0)
        progress = 0;
      else {
        var delta: int = int((System.currentTimeMillis__() - startTime));
        if (delta >= duration)
          progress = 1.0;
        else
          progress = 0.10000000149011612 + 0.8999999761581421 * delta / duration;
      }
    }
    return;
  }
  private static function findUpdateManager__(): void {
    var pair: Animation$AnimPair = Animation$AnimPair(Iterator(figureAnimators.iterator__()).next__());
    updateManager = pair.figure.getUpdateManager__();
    return;
  }
  public static function getFinalState__Lorg_eclipse_draw2d_Animator_2Lorg_eclipse_draw2d_IFigure_2(animator: Animator, figure: IFigure): Object {
    return finalStates.get__Ljava_lang_Object_2(new Animation$AnimPair(animator, figure));
  }
  public static function getInitialState__Lorg_eclipse_draw2d_Animator_2Lorg_eclipse_draw2d_IFigure_2(animator: Animator, figure: IFigure): Object {
    return initialStates.get__Ljava_lang_Object_2(new Animation$AnimPair(animator, figure));
  }
  public static function getProgress__(): Number {
    return progress;
  }
  public static function hookAnimator__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Animator_2(figure: IFigure, animator: Animator): void {
    var pair: Animation$AnimPair = new Animation$AnimPair(animator, figure);
    if (figureAnimators.add__Ljava_lang_Object_2(pair))
      animator.init__Lorg_eclipse_draw2d_IFigure_2(figure);
  }
  public static function hookNeedsCapture__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Animator_2(figure: IFigure, animator: Animator): void {
    var pair: Animation$AnimPair = new Animation$AnimPair(animator, figure);
    if (figureAnimators.contains__Ljava_lang_Object_2(pair))
      toCapture.add__Ljava_lang_Object_2(pair);
  }
  public static function hookPlayback__Lorg_eclipse_draw2d_IFigure_2Lorg_eclipse_draw2d_Animator_2(figure: IFigure, animator: Animator): Boolean {
    if (toCapture.contains__Ljava_lang_Object_2(new Animation$AnimPair(animator, figure)))
      return animator.playback__Lorg_eclipse_draw2d_IFigure_2(figure);
    return false;
  }
  public static function isAnimating__(): Boolean {
    return state == 3;
  }
  public static function isFinalRecording__(): Boolean {
    return state == 2;
  }
  public static function isInitialRecording__(): Boolean {
    return state == 1;
  }
  public static function markBegin__(): Boolean {
    if (state == 0) {
      state = 1;
      initialStates = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
      finalStates = new HashMap(new Arguments(java.util.HashMap.HashMap__, []));
      figureAnimators = new HashSet(new Arguments(java.util.HashSet.HashSet__, []));
      toCapture = new HashSet(new Arguments(java.util.HashSet.HashSet__, []));
      return true;
    }
    return false;
  }
  private static function notifyPlaybackStarting__(): void {
    var keys: Iterator = Iterator(figureAnimators.iterator__());
    while (keys.hasNext__()) {
      var pair: Animation$AnimPair = Animation$AnimPair(keys.next__());
      pair.animator.playbackStarting__Lorg_eclipse_draw2d_IFigure_2(pair.figure);
    }
    return;
  }
  public static function putFinalState__Lorg_eclipse_draw2d_Animator_2Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(animator: Animator, key: IFigure, state: Object): void {
    finalStates.put__Ljava_lang_Object_2Ljava_lang_Object_2(new Animation$AnimPair(animator, key), state);
    return;
  }
  public static function putInitialState__Lorg_eclipse_draw2d_Animator_2Lorg_eclipse_draw2d_IFigure_2Ljava_lang_Object_2(animator: Animator, key: IFigure, state: Object): void {
    initialStates.put__Ljava_lang_Object_2Ljava_lang_Object_2(new Animation$AnimPair(animator, key), state);
    return;
  }
  public static function run__(): void {
    run__I(250);
    return;
  }
  public static function run__I(duration: int): void {
    if (state == 0)
      return;
    try {
      if (!figureAnimators.isEmpty__())
        doRun__I(duration);
    } finally {
      cleanup__();
    }
    return;
  }
  private static function step__(): void {
    var iter: Iterator = Iterator(initialStates.keySet__().iterator__());
    while (iter.hasNext__())
      (Animation$AnimPair(iter.next__())).figure.revalidate__();
    return;
  }
}
}
