package org.eclipse.draw2d {
import java.util.ArrayList;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.internal.MultiValueMap;
import java.util.ArrayList;
dynamic public class AutomaticRouter extends AbstractRouter {
  private var nextRouter: ConnectionRouter;
  private var connections: MultiValueMap = new MultiValueMap();
  public override function getConstraint__Lorg_eclipse_draw2d_Connection_2(connection: Connection): Object {
    if (this.next__() !== null)
      return this.next__().getConstraint__Lorg_eclipse_draw2d_Connection_2(connection);
    return null;
  }
  public function handleCollision__Lorg_eclipse_draw2d_geometry_PointList_2I(list: PointList, index: int): void { } // abstract
  public override function invalidate__Lorg_eclipse_draw2d_Connection_2(conn: Connection): void {
    if (this.next__() !== null)
      this.next__().invalidate__Lorg_eclipse_draw2d_Connection_2(conn);
    if (conn.getSourceAnchor__() === null || conn.getTargetAnchor__() === null)
      return;
    var connectionKey: AutomaticRouter$HashKey = new AutomaticRouter$HashKey(this, conn);
    var connectionList: ArrayList = connections.get__Ljava_lang_Object_2(connectionKey);
    var affected: int = connections.remove__Ljava_lang_Object_2Ljava_lang_Object_2(connectionKey, conn);
    if (affected != -1) {
      for (var i: int = affected; i < connectionList.size__(); i++)
        (Connection(connectionList.get__I(i))).revalidate__();
    } else
      connections.removeValue__Ljava_lang_Object_2(conn);
    return;
  }
  public function next__(): ConnectionRouter {
    return nextRouter;
  }
  public override function remove__Lorg_eclipse_draw2d_Connection_2(conn: Connection): void {
    if (conn.getSourceAnchor__() === null || conn.getTargetAnchor__() === null)
      return;
    var connectionKey: AutomaticRouter$HashKey = new AutomaticRouter$HashKey(this, conn);
    var connectionList: ArrayList = connections.get__Ljava_lang_Object_2(connectionKey);
    if (connectionList !== null) {
      var index: int = connections.remove__Ljava_lang_Object_2Ljava_lang_Object_2(connectionKey, conn);
      for (var i: int = index + 1; i < connectionList.size__(); i++)
        (Connection(connectionList.get__I(i))).revalidate__();
    }
    if (this.next__() !== null)
      this.next__().remove__Lorg_eclipse_draw2d_Connection_2(conn);
    return;
  }
  public override function route__Lorg_eclipse_draw2d_Connection_2(conn: Connection): void {
    if (this.next__() !== null)
      this.next__().route__Lorg_eclipse_draw2d_Connection_2(conn);
    else {
      conn.getPoints__().removeAllPoints__();
      this.setEndPoints__Lorg_eclipse_draw2d_Connection_2(conn);
    }
    if (conn.getPoints__().size__() == 2) {
      var points: PointList = conn.getPoints__();
      var connectionKey: AutomaticRouter$HashKey = new AutomaticRouter$HashKey(this, conn);
      var connectionList: ArrayList = connections.get__Ljava_lang_Object_2(connectionKey);
      if (connectionList !== null) {
        var index: int;
        if (connectionList.contains__Ljava_lang_Object_2(conn)) {
          index = connectionList.indexOf__Ljava_lang_Object_2(conn) + 1;
        } else {
          index = connectionList.size__() + 1;
          connections.put__Ljava_lang_Object_2Ljava_lang_Object_2(connectionKey, conn);
        }
        this.handleCollision__Lorg_eclipse_draw2d_geometry_PointList_2I(points, index);
        conn.setPoints__Lorg_eclipse_draw2d_geometry_PointList_2(points);
      } else {
        connections.put__Ljava_lang_Object_2Ljava_lang_Object_2(connectionKey, conn);
      }
    }
    return;
  }
  public override function setConstraint__Lorg_eclipse_draw2d_Connection_2Ljava_lang_Object_2(connection: Connection, constraint: Object): void {
    this.invalidate__Lorg_eclipse_draw2d_Connection_2(connection);
    if (this.next__() !== null)
      this.next__().setConstraint__Lorg_eclipse_draw2d_Connection_2Ljava_lang_Object_2(connection, constraint);
    return;
  }
  public function setEndPoints__Lorg_eclipse_draw2d_Connection_2(conn: Connection): void {
    var points: PointList = conn.getPoints__();
    points.removeAllPoints__();
    var start: Point = this.getStartPoint__Lorg_eclipse_draw2d_Connection_2(conn);
    var end: Point = this.getEndPoint__Lorg_eclipse_draw2d_Connection_2(conn);
    conn.translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(start);
    conn.translateToRelative__Lorg_eclipse_draw2d_geometry_Translatable_2(end);
    points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(start);
    points.addPoint__Lorg_eclipse_draw2d_geometry_Point_2(end);
    conn.setPoints__Lorg_eclipse_draw2d_geometry_PointList_2(points);
    return;
  }
  public function setNextRouter__Lorg_eclipse_draw2d_ConnectionRouter_2(router: ConnectionRouter): void {
    nextRouter = router;
    return;
  }
}
}
